/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fulcrum.parser.ParameterParser;
import org.apache.turbine.Turbine;
import org.apache.turbine.modules.Action;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.util.RunData;

public abstract class ActionEvent
extends Action {
    protected Log log = LogFactory.getLog(this.getClass());
    private static final Class[] methodParams = new Class[]{RunData.class};
    protected static final String BUTTON = "eventSubmit_";
    protected static final int BUTTON_LENGTH = "eventSubmit_".length();
    protected static final String METHOD_NAME_PREFIX = "do";
    protected static final int METHOD_NAME_LENGTH = "do".length();
    protected static final int LENGTH = "eventSubmit_".length();
    private boolean submitValueKey = Turbine.getConfiguration().getBoolean("action.eventsubmit.needsvalue", false);
    protected boolean bubbleUpException = Turbine.getConfiguration().getBoolean("action.event.bubbleexception", true);

    @Override
    @Deprecated
    public abstract void doPerform(RunData var1) throws Exception;

    @Override
    public void doPerform(PipelineData pipelineData) throws Exception {
        RunData data = this.getRunData(pipelineData);
        this.doPerform(data);
    }

    public ActionEvent() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.submitValueKey ? "ActionEvent accepts only eventSubmit_do Keys with a value != 0" : "ActionEvent accepts all eventSubmit_do Keys"));
            this.log.debug((Object)(this.bubbleUpException ? "ActionEvent will bubble exceptions up to Turbine.handleException() method" : "ActionEvent will not bubble exceptions up."));
        }
    }

    @Override
    @Deprecated
    protected void perform(RunData data) throws Exception {
        try {
            this.executeEvents(data);
        }
        catch (NoSuchMethodException e) {
            this.doPerform(data);
        }
    }

    @Override
    protected void perform(PipelineData pipelineData) throws Exception {
        try {
            this.executeEvents(pipelineData);
        }
        catch (NoSuchMethodException e) {
            this.doPerform(pipelineData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void executeEvents(RunData data) throws Exception {
        String theButton = null;
        ParameterParser pp = data.getParameters();
        String button = pp.convert(BUTTON);
        String key2 = null;
        for (String key2 : pp.keySet()) {
            if (!key2.startsWith(button) || !this.considerKey(key2, pp)) continue;
            theButton = this.formatString(key2, pp);
            break;
        }
        if (theButton == null) {
            throw new NoSuchMethodException("ActionEvent: The button was null");
        }
        Method method = null;
        try {
            method = this.getClass().getMethod(theButton, methodParams);
            Object[] methodArgs = new Object[]{data};
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Invoking " + method));
            }
            method.invoke((Object)this, methodArgs);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            this.log.error((Object)("Invokation of " + method), t);
        }
        finally {
            pp.remove(key2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeEvents(PipelineData pipelineData) throws Exception {
        RunData data = this.getRunData(pipelineData);
        String theButton = null;
        ParameterParser pp = data.getParameters();
        String button = pp.convert(BUTTON);
        String key2 = null;
        for (String key2 : pp.keySet()) {
            if (!key2.startsWith(button) || !this.considerKey(key2, pp)) continue;
            theButton = this.formatString(key2, pp);
            break;
        }
        if (theButton == null) {
            throw new NoSuchMethodException("ActionEvent: The button was null");
        }
        Method method = null;
        try {
            method = this.getClass().getMethod(theButton, methodParams);
            Object[] methodArgs = new Object[]{pipelineData};
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Invoking " + method));
            }
            method.invoke((Object)this, methodArgs);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            this.log.error((Object)("Invokation of " + method), t);
        }
        finally {
            pp.remove(key2);
        }
    }

    protected final String formatString(String input, ParameterParser pp) {
        String tmp = input;
        if (StringUtils.isNotEmpty((String)input)) {
            tmp = input.toLowerCase();
            String string = input = tmp.endsWith(".x") || tmp.endsWith(".y") ? input.substring(0, input.length() - 2) : input;
            if (pp.getUrlFolding() != 1) {
                tmp = input.toLowerCase().substring(BUTTON_LENGTH + METHOD_NAME_LENGTH);
                tmp = METHOD_NAME_PREFIX + StringUtils.capitalize((String)tmp);
            } else {
                tmp = input.substring(BUTTON_LENGTH);
            }
        }
        return tmp;
    }

    protected boolean considerKey(String key, ParameterParser pp) {
        if (!this.submitValueKey) {
            this.log.debug((Object)("No Value required, accepting " + key));
            return true;
        }
        String keyValue = pp.getString(key);
        this.log.debug((Object)("Key Value is " + keyValue));
        if (StringUtils.isEmpty((String)keyValue)) {
            this.log.debug((Object)("Key is empty, rejecting " + key));
            return false;
        }
        try {
            if (Integer.parseInt(keyValue) != 0) {
                this.log.debug((Object)("Integer != 0, accepting " + key));
                return true;
            }
        }
        catch (NumberFormatException nfe) {
            this.log.debug((Object)("Not a number, accepting " + key));
            return true;
        }
        this.log.debug((Object)("Rejecting " + key));
        return false;
    }
}

