/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.adapter;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.torque.TorqueException;
import org.apache.torque.adapter.DB;
import org.apache.torque.util.Query;

public abstract class AbstractDBAdapter
implements DB {
    protected AbstractDBAdapter() {
    }

    public abstract String toUpperCase(String var1);

    public char getStringDelimiter() {
        return '\'';
    }

    public abstract String getIDMethodType();

    public abstract String getIDMethodSQL(Object var1);

    public abstract void lockTable(Connection var1, String var2) throws SQLException;

    public abstract void unlockTable(Connection var1, String var2) throws SQLException;

    public abstract String ignoreCase(String var1);

    public String ignoreCaseInOrderBy(String in) {
        return this.ignoreCase(in);
    }

    public boolean supportsNativeLimit() {
        return false;
    }

    public boolean supportsNativeOffset() {
        return false;
    }

    public void generateLimits(Query query, int offset, int limit) throws TorqueException {
        if (this.supportsNativeLimit()) {
            query.setLimit(String.valueOf(limit));
        }
    }

    public boolean escapeText() {
        return true;
    }

    public int getLimitStyle() {
        return 0;
    }

    public String getDateString(Date date) {
        Timestamp ts = null;
        ts = date instanceof Timestamp ? (Timestamp)date : new Timestamp(date.getTime());
        return "{ts '" + ts + "'}";
    }

    public String getBooleanString(Boolean b) {
        return Boolean.TRUE.equals(b) ? "1" : "0";
    }

    public boolean useIlike() {
        return false;
    }

    public boolean useEscapeClauseForLike() {
        return false;
    }
}

