/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.yaafi.service.baseservice;

import java.io.File;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.fulcrum.yaafi.service.baseservice.BaseService;

public abstract class BaseServiceImpl
extends AbstractLogEnabled
implements BaseService {
    private String serviceName;
    private Context serviceContext;
    private ServiceManager serviceManager;
    private Configuration serviceConfiguration;
    private Parameters serviceParameters;
    private File serviceApplicationDir;
    private File serviceTempDir;
    private String servicePartitionName;
    private ClassLoader serviceClassLoader;

    public void contextualize(Context context) throws ContextException {
        this.serviceContext = context;
        this.serviceName = (String)context.get((Object)"urn:avalon:name");
        this.serviceApplicationDir = (File)context.get((Object)"urn:avalon:home");
        this.serviceTempDir = (File)context.get((Object)"urn:avalon:temp");
        this.servicePartitionName = (String)context.get((Object)"urn:avalon:partition");
        this.serviceClassLoader = (ClassLoader)context.get((Object)"urn:avalon:classloader");
    }

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.serviceManager = serviceManager;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.serviceConfiguration = configuration;
    }

    public void parameterize(Parameters parameters) throws ParameterException {
        this.serviceParameters = parameters;
    }

    public void reconfigure(Configuration configuration) throws ConfigurationException {
        this.serviceConfiguration = configuration;
    }

    public void dispose() {
        this.serviceApplicationDir = null;
        this.serviceClassLoader = null;
        this.serviceConfiguration = null;
        this.serviceContext = null;
        this.serviceManager = null;
        this.serviceName = null;
        this.serviceParameters = null;
        this.servicePartitionName = null;
        this.serviceTempDir = null;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()));
        result.append("{");
        result.append("serviceName: ");
        result.append(this.getServiceName());
        result.append(";");
        result.append(" servicePartitionName: ");
        result.append(this.getServicePartitionName());
        result.append(";");
        result.append(" serviceApplicatonDir: ");
        result.append(this.getServiceApplicationDir().getAbsolutePath());
        result.append(";");
        result.append(" serviceTempDir: ");
        result.append(this.getServiceTempDir().getAbsolutePath());
        result.append(";");
        result.append(" serviceContext: ");
        result.append(this.getServiceContext().toString());
        result.append(";");
        result.append(" serviceConfiguration: ");
        result.append(this.getServiceConfiguration().toString());
        result.append(";");
        result.append(" serviceParameters: ");
        result.append(Parameters.toProperties((Parameters)this.getServiceParameters()));
        result.append(";");
        result.append(" serviceClassLoader: ");
        result.append(this.getServiceClassLoader());
        result.append(";");
        result.append(" serviceLogger: ");
        result.append(this.getLogger());
        result.append(";");
        result.append(" serviceManager: ");
        result.append(this.getServiceManager());
        result.append("}");
        return result.toString();
    }

    protected boolean hasService(String key) {
        return this.getServiceManager().hasService(key);
    }

    protected Object lookup(String key) {
        try {
            return this.getServiceManager().lookup(key);
        }
        catch (ServiceException e) {
            String msg = "Unable to lookup the following service : " + key;
            this.getLogger().error(msg, (Throwable)e);
            throw new RuntimeException(msg);
        }
    }

    protected void release(Object object) {
        this.release(object);
    }

    protected File createAbsoluteFile(String fileName) {
        File result = new File(fileName);
        if (!result.isAbsolute()) {
            result = new File(this.getServiceApplicationDir(), fileName);
        }
        return result;
    }

    protected String createAbsolutePath(String fileName) {
        return this.createAbsoluteFile(fileName).getAbsolutePath();
    }

    protected File getServiceApplicationDir() {
        return this.serviceApplicationDir;
    }

    protected ClassLoader getServiceClassLoader() {
        return this.serviceClassLoader;
    }

    protected Configuration getServiceConfiguration() {
        return this.serviceConfiguration;
    }

    protected Context getServiceContext() {
        return this.serviceContext;
    }

    protected ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    protected String getServiceName() {
        return this.serviceName;
    }

    protected Parameters getServiceParameters() {
        return this.serviceParameters;
    }

    protected String getServicePartitionName() {
        return this.servicePartitionName;
    }

    protected File getServiceTempDir() {
        return this.serviceTempDir;
    }
}

