/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.yaafi.interceptor.util;

import java.lang.reflect.Method;
import org.apache.fulcrum.yaafi.framework.util.StringUtils;
import org.apache.fulcrum.yaafi.interceptor.util.InterceptorToStringBuilder;

public class MethodToStringBuilderImpl
implements InterceptorToStringBuilder {
    public static final int INCLUDE_RETURNTYPE = 1;
    private static int defaultMode = 1;
    private int mode;
    private static final int BUF_SIZE = 512;
    private Method method;

    public MethodToStringBuilderImpl() {
        this.mode = defaultMode;
    }

    public MethodToStringBuilderImpl(Method method) {
        this.method = method;
        this.mode = defaultMode;
    }

    public MethodToStringBuilderImpl(Method method, int mode) {
        this.method = method;
        this.mode = mode;
    }

    public void setMaxArgLength(int maxArgLength) {
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public void setTarget(Object target) {
        this.method = (Method)target;
    }

    public String toString() {
        try {
            StringBuffer buffer = new StringBuffer(512);
            Class<?> returnType = this.method.getReturnType();
            Class<?> declaringClass = this.method.getDeclaringClass();
            Class<?>[] params = this.method.getParameterTypes();
            if ((this.mode & 1) == 1) {
                buffer.append(this.stripDefaultPackage(returnType.getName()));
                buffer.append(' ');
            }
            buffer.append(this.stripDefaultPackage(declaringClass.getName()));
            buffer.append('.');
            buffer.append(this.method.getName());
            buffer.append('(');
            for (int i = 0; i < params.length; ++i) {
                buffer.append(this.stripDefaultPackage(params[i].getName()));
                if (i >= params.length - 1) continue;
                buffer.append(",");
            }
            buffer.append(")");
            return buffer.toString();
        }
        catch (Throwable t) {
            return "<" + t + ">";
        }
    }

    private String stripDefaultPackage(String arg) {
        if (arg.charAt(0) == '[') {
            return StringUtils.replaceChars(arg, ';', '#');
        }
        return StringUtils.replace(arg, "java.lang.", "");
    }
}

