/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.parser;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang.StringUtils;
import org.apache.fulcrum.parser.ParserService;
import org.apache.fulcrum.parser.ParserServiceSupport;
import org.apache.fulcrum.parser.ValueParser;
import org.apache.fulcrum.pool.PoolException;
import org.apache.fulcrum.pool.PoolService;
import org.apache.fulcrum.upload.UploadService;

public class DefaultParserService
extends AbstractLogEnabled
implements ParserService,
Configurable,
Serviceable {
    private int folding = 1;
    private boolean automaticUpload = false;
    private String parameterEncoding = "ISO-8859-1";
    private UploadService uploadService = null;
    private PoolService poolService = null;

    public String getParameterEncoding() {
        return this.parameterEncoding;
    }

    public String convert(String value) {
        return this.convertAndTrim(value);
    }

    public String convertAndTrim(String value) {
        return this.convertAndTrim(value, this.getUrlFolding());
    }

    public String convertAndTrim(String value, int fold) {
        if (value == null) {
            return "";
        }
        String tmp = value.trim();
        switch (fold) {
            case 1: {
                break;
            }
            case 2: {
                tmp = tmp.toLowerCase();
                break;
            }
            case 3: {
                tmp = tmp.toUpperCase();
                break;
            }
            default: {
                this.getLogger().error("Passed " + fold + " as fold rule, which is illegal!");
            }
        }
        return tmp;
    }

    public int getUrlFolding() {
        return this.folding;
    }

    public boolean getAutomaticUpload() {
        return this.automaticUpload;
    }

    public List parseUpload(HttpServletRequest request) throws ServiceException {
        if (this.uploadService == null) {
            throw new ServiceException(ParserService.ROLE, "UploadService is not available.");
        }
        return this.uploadService.parseRequest(request);
    }

    public ValueParser getParser(Class ppClass) throws InstantiationException {
        ValueParser vp = null;
        try {
            vp = (ValueParser)this.poolService.getInstance(ppClass);
            if (vp instanceof ParserServiceSupport) {
                ((ParserServiceSupport)((Object)vp)).setParserService(this);
            }
            if (vp instanceof LogEnabled) {
                ((LogEnabled)vp).enableLogging(this.getLogger().getChildLogger(ppClass.getName()));
            }
        }
        catch (PoolException pe) {
            throw new InstantiationException("Parser class '" + ppClass + "' is illegal. " + pe.getMessage());
        }
        catch (ClassCastException x) {
            throw new InstantiationException("Parser class '" + ppClass + "' is illegal. " + x.getMessage());
        }
        return vp;
    }

    public void putParser(ValueParser parser) {
        parser.clear();
        this.poolService.putInstance((Object)parser);
    }

    public void configure(Configuration conf) throws ConfigurationException {
        if (this.folding == 0) {
            String foldString = conf.getChild("urlCaseFolding").getValue("none").toLowerCase();
            this.folding = 1;
            this.getLogger().debug("Setting folding from " + foldString);
            if (StringUtils.isNotEmpty((String)foldString)) {
                if (foldString.equals("none")) {
                    this.folding = 1;
                } else if (foldString.equals("lower")) {
                    this.folding = 2;
                } else if (foldString.equals("upper")) {
                    this.folding = 3;
                } else {
                    this.getLogger().error("Got " + foldString + " from " + "urlCaseFolding" + " property, which is illegal!");
                    throw new ConfigurationException("Value " + foldString + " is illegal!");
                }
            }
        }
        this.parameterEncoding = conf.getChild("parameterEncoding").getValue("ISO-8859-1").toLowerCase();
        this.automaticUpload = conf.getAttributeAsBoolean("automaticUpload", false);
    }

    public void service(ServiceManager manager) throws ServiceException {
        if (manager.hasService(UploadService.ROLE)) {
            this.uploadService = (UploadService)manager.lookup(UploadService.ROLE);
        } else if (this.getAutomaticUpload()) {
            throw new ServiceException(ParserService.ROLE, "automaticUpload = true requires " + UploadService.ROLE + " to be available");
        }
        if (!manager.hasService(PoolService.ROLE)) {
            throw new ServiceException(ParserService.ROLE, "Service requires " + PoolService.ROLE + " to be available");
        }
        this.poolService = (PoolService)manager.lookup(PoolService.ROLE);
    }
}

