/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.parser;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.fulcrum.parser.BaseValueParser;
import org.apache.fulcrum.parser.CookieParser;

public class DefaultCookieParser
extends BaseValueParser
implements CookieParser {
    private HttpServletRequest request;
    private HttpServletResponse response;

    public void dispose() {
        this.request = null;
        super.dispose();
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setData(HttpServletRequest request, HttpServletResponse response) {
        this.clear();
        String enc = request.getCharacterEncoding();
        this.setCharacterEncoding(enc != null ? enc : "US-ASCII");
        Cookie[] cookies = request.getCookies();
        this.getLogger().debug("Number of Cookies " + cookies.length);
        for (int i = 0; i < cookies.length; ++i) {
            String name = this.convert(cookies[i].getName());
            String value = cookies[i].getValue();
            this.getLogger().debug("Adding " + name + "=" + value);
            this.add(name, value);
        }
        this.request = request;
        this.response = response;
    }

    public void set(String name, String value) {
        this.set(name, value, -1);
    }

    public void set(String name, String value, int seconds_age) {
        if (this.response == null) {
            throw new IllegalStateException("Servlet response not available");
        }
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(seconds_age);
        cookie.setPath(this.request.getServletPath());
        this.response.addCookie(cookie);
    }

    public void unset(String name) {
        this.set(name, " ", 0);
    }
}

