/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker.metadata;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class PersistentField {
    private Field field;

    public PersistentField(Field f) {
        this.field = f;
    }

    public void set(Object obj, Object value) throws IllegalAccessException {
        boolean before = this.field.isAccessible();
        AccessController.doPrivileged(new SetAccessibleAction());
        this.field.set(obj, value);
        ((AccessibleObject)this.field).setAccessible(before);
    }

    public Object get(Object obj) throws IllegalAccessException {
        boolean before = this.field.isAccessible();
        AccessController.doPrivileged(new SetAccessibleAction());
        Object result = this.field.get(obj);
        ((AccessibleObject)this.field).setAccessible(before);
        return result;
    }

    public Class getType() {
        return this.field.getType();
    }

    public String getName() {
        return this.field.getName();
    }

    public Class getDeclaringClass() {
        return this.field.getDeclaringClass();
    }

    private class SetAccessibleAction
    implements PrivilegedAction {
        private SetAccessibleAction() {
        }

        public Object run() {
            ((AccessibleObject)PersistentField.this.field).setAccessible(true);
            return null;
        }
    }
}

