/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.jobs;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;
import org.quartz.StatefulJob;
import org.quartz.jobs.FileScanListener;

public class FileScanJob
implements StatefulJob {
    public static String FILE_NAME = "FILE_NAME";
    public static String FILE_SCAN_LISTENER_NAME = "FILE_SCAN_LISTENER_NAME";
    private static String LAST_MODIFIED_TIME = "LAST_MODIFIED_TIME";

    public void execute(JobExecutionContext context) throws JobExecutionException {
        File file;
        Log log = LogFactory.getLog(this.getClass());
        JobDataMap data = context.getJobDetail().getJobDataMap();
        SchedulerContext schedCtxt = null;
        try {
            schedCtxt = context.getScheduler().getContext();
        }
        catch (SchedulerException e) {
            throw new JobExecutionException("Error obtaining scheduler context.", (Exception)e, false);
        }
        String fileName = data.getString(FILE_NAME);
        String listenerName = data.getString(FILE_SCAN_LISTENER_NAME);
        if (fileName == null) {
            throw new JobExecutionException("Required parameter '" + FILE_NAME + "' not found in JobDataMap");
        }
        if (listenerName == null) {
            throw new JobExecutionException("Required parameter '" + FILE_SCAN_LISTENER_NAME + "' not found in JobDataMap");
        }
        FileScanListener listener = (FileScanListener)schedCtxt.get(listenerName);
        if (listener == null) {
            throw new JobExecutionException("FileScanListener named '" + listenerName + "' not found in SchedulerContext");
        }
        long lastDate = -1L;
        if (data.containsKey(LAST_MODIFIED_TIME)) {
            lastDate = data.getLong(LAST_MODIFIED_TIME);
        }
        if (!(file = new File(fileName)).exists()) {
            log.warn((Object)("File '" + fileName + "' does not exist."));
            return;
        }
        long newDate = file.lastModified();
        if (lastDate > 0L && newDate != lastDate) {
            log.info((Object)("File '" + fileName + "' updated, notifying listener."));
            listener.fileUpdated(fileName);
        } else {
            log.debug((Object)("File '" + fileName + "' unchanged."));
        }
        data.put(LAST_MODIFIED_TIME, newDate);
    }
}

