/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.policy;

import java.util.List;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.policy.SimpleDispatchPolicy;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.filter.MessageEvaluationContext;

public class ClientIdFilterDispatchPolicy
extends SimpleDispatchPolicy {
    public static final String PTP_CLIENTID = "PTP_CLIENTID";
    public static final String PTP_SUFFIX = ".PTP";
    private String ptpClientId = "PTP_CLIENTID";
    private String ptpSuffix = ".PTP";

    @Override
    public boolean dispatch(MessageReference node, MessageEvaluationContext msgContext, List<Subscription> consumers) throws Exception {
        Object _clientId = node.getMessage().getProperty(this.ptpClientId);
        if (_clientId == null) {
            return super.dispatch(node, msgContext, consumers);
        }
        ActiveMQDestination _destination = node.getMessage().getDestination();
        int count = 0;
        for (Subscription sub : consumers) {
            if (sub.getConsumerInfo().isBrowser()) continue;
            if (!sub.matches(node, msgContext)) {
                sub.unmatched(node);
                continue;
            }
            if (_clientId != null && _destination.isTopic() && _clientId.equals(sub.getContext().getClientId()) && _destination.getQualifiedName().endsWith(this.ptpSuffix)) {
                sub.add(node);
                ++count;
                continue;
            }
            sub.unmatched(node);
        }
        return count > 0;
    }

    public String getPtpClientId() {
        return this.ptpClientId;
    }

    public void setPtpClientId(String ptpClientId) {
        this.ptpClientId = ptpClientId;
    }

    public String getPtpSuffix() {
        return this.ptpSuffix;
    }

    public void setPtpSuffix(String ptpSuffix) {
        this.ptpSuffix = ptpSuffix;
    }
}

