/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Utils;

final class MethodParamList {
    private final MethodInfo method;
    private final List<ParamData> proper = new ArrayList<ParamData>();
    private final List<ParamData> debug = new ArrayList<ParamData>();
    private ParamData[] possiblyNamed;
    private boolean firstIsEnclosingInstance;

    MethodParamList(MethodInfo method) {
        this.method = method;
    }

    void appendProper(byte[] parameterName, boolean synthetic) {
        this.proper.add(new ParamData(parameterName, synthetic));
    }

    void appendDebug(byte[] parameterName, boolean synthetic) {
        this.debug.add(new ParamData(parameterName, synthetic));
    }

    void finish() {
        List<ParamData> proper = this.proper;
        List<ParamData> debug = this.debug;
        if (proper.isEmpty() && debug.isEmpty()) {
            this.possiblyNamed = ParamData.EMPTY_ARRAY;
            return;
        }
        if (proper.isEmpty()) {
            List<ParamData> list = debug;
            if (debug.get((int)0).syntheticOrMandated) {
                list = debug.subList(1, debug.size());
                this.firstIsEnclosingInstance = true;
            }
            this.possiblyNamed = list.toArray(ParamData.EMPTY_ARRAY);
            return;
        }
        if (this.method.isConstructor() && !this.method.declaringClass().isRecord()) {
            if (this.method.declaringClass().isEnum()) {
                proper = proper.subList(2, this.method.parametersCount());
            } else {
                if (proper.get((int)0).syntheticOrMandated && !debug.isEmpty() && debug.get((int)0).syntheticOrMandated) {
                    debug.remove(0);
                    this.firstIsEnclosingInstance = true;
                }
                Iterator<ParamData> it = proper.iterator();
                while (it.hasNext()) {
                    ParamData param = it.next();
                    if (!param.syntheticOrMandated) continue;
                    it.remove();
                }
            }
        }
        if (debug.isEmpty()) {
            this.possiblyNamed = proper.toArray(ParamData.EMPTY_ARRAY);
            return;
        }
        int size = Math.min(proper.size(), debug.size());
        ParamData[] result = new ParamData[size];
        for (int i = 0; i < size; ++i) {
            ParamData resultParameter;
            ParamData properParameter = proper.get(i);
            ParamData debugParameter = debug.get(i);
            result[i] = resultParameter = new ParamData(properParameter.name != null ? properParameter.name : debugParameter.name, properParameter.syntheticOrMandated || debugParameter.syntheticOrMandated);
        }
        this.possiblyNamed = result;
    }

    boolean firstIsEnclosingInstance() {
        return this.firstIsEnclosingInstance;
    }

    byte[][] getNames() {
        ParamData[] params = this.possiblyNamed;
        int count = 0;
        boolean seenNamed = false;
        for (int i = params.length - 1; i >= 0; --i) {
            if (!seenNamed && params[i].name == null) continue;
            seenNamed = true;
            ++count;
        }
        if (count == 0) {
            return null;
        }
        byte[][] result = new byte[count][];
        int pos = 0;
        for (int i = 0; i < params.length; ++i) {
            result[pos] = params[i].name;
            if (++pos >= result.length) break;
        }
        for (byte[] name : result) {
            if (name != null) continue;
            return null;
        }
        return result;
    }

    static final class ParamData {
        static final ParamData[] EMPTY_ARRAY = new ParamData[0];
        final byte[] name;
        final boolean syntheticOrMandated;

        ParamData(byte[] name, boolean syntheticOrMandated) {
            this.name = name;
            this.syntheticOrMandated = syntheticOrMandated;
        }

        public String toString() {
            return (this.name == null ? "<null>" : Utils.fromUTF8(this.name)) + (this.syntheticOrMandated ? "<synth>" : "");
        }
    }
}

