/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.swizzle.stream;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.tomitribe.swizzle.stream.FilteredInputStream;
import org.tomitribe.swizzle.stream.ScanBuffer;
import org.tomitribe.swizzle.stream.StreamTokenHandler;

public class DelimitedTokenReplacementInputStream
extends FilteredInputStream {
    private final ScanBuffer beginBuffer;
    private final ScanBuffer endBuffer;
    private InputStream value;
    private final StreamTokenHandler handler;
    private StreamReadingStrategy strategy;
    StringBuilder token = new StringBuilder();

    public DelimitedTokenReplacementInputStream(InputStream in, String begin, String end, StreamTokenHandler tokenHandler) {
        this(in, begin, end, tokenHandler, true);
    }

    public DelimitedTokenReplacementInputStream(InputStream in, String begin, String end, StreamTokenHandler tokenHandler, boolean caseSensitive) {
        super(in);
        this.handler = tokenHandler;
        this.beginBuffer = new ScanBuffer(begin, caseSensitive);
        this.endBuffer = new ScanBuffer(end, caseSensitive);
        this.strategy = this::fillBeginBuffer;
    }

    @Override
    public int read() throws IOException {
        return this.strategy.read();
    }

    private int fillBeginBuffer() throws IOException {
        for (int i = 0; i < this.beginBuffer.size(); ++i) {
            int stream = this.streamRead();
            this.beginBuffer.append(stream);
        }
        this.strategy = this.beginBuffer.match() ? this::fillEndBuffer : this::scanBegin;
        return this.strategy.read();
    }

    private int scanBegin() throws IOException {
        int buffered = this.beginBuffer.append(this.streamRead());
        if (this.beginBuffer.match()) {
            this.strategy = this::fillEndBuffer;
        }
        return buffered;
    }

    private int fillEndBuffer() throws IOException {
        for (int i = 0; i < this.endBuffer.size(); ++i) {
            int stream = this.streamRead();
            this.endBuffer.append(stream);
        }
        if (this.endBuffer.match()) {
            this.endBuffer.flush();
            this.strategy = this::startReplacement;
        } else {
            this.strategy = this::scanEnd;
        }
        return this.strategy.read();
    }

    private int scanEnd() throws IOException {
        int buffered;
        this.token = new StringBuilder();
        do {
            if ((buffered = this.endBuffer.append(this.streamRead())) != -1) {
                this.token.append((char)buffered);
            }
            if (!this.endBuffer.match()) continue;
            this.endBuffer.flush();
            this.strategy = this::startReplacement;
            return this.strategy.read();
        } while (buffered != -1);
        this.strategy = this::endNotFound;
        return this.strategy.read();
    }

    private int startReplacement() throws IOException {
        String token;
        if (this.token == null) {
            token = "";
        } else {
            token = this.token.toString();
            this.token = null;
        }
        this.value = this.handler.processToken(token);
        this.strategy = this.value != null ? this::flushReplacement : this::fillBeginBuffer;
        return this.strategy.read();
    }

    private int flushReplacement() throws IOException {
        int i = this.value.read();
        if (i != -1) {
            return i;
        }
        this.strategy = this::fillBeginBuffer;
        return this.strategy.read();
    }

    private int endNotFound() throws IOException {
        this.strategy = this::drainBeginBuffer;
        return this.strategy.read();
    }

    private int drainBeginBuffer() throws IOException {
        int buffered = this.beginBuffer.append(-1);
        if (buffered != -1) {
            return buffered;
        }
        this.value = new ByteArrayInputStream(this.token.toString().getBytes());
        this.token = null;
        this.strategy = this::drainTokenBuffer;
        return this.strategy.read();
    }

    private int drainTokenBuffer() throws IOException {
        int buffered = this.value.read();
        if (buffered != -1) {
            return buffered;
        }
        this.strategy = this::done;
        return this.strategy.read();
    }

    private int done() throws IOException {
        return -1;
    }

    private int streamRead() throws IOException {
        return super.read();
    }

    static interface StreamReadingStrategy {
        public int read() throws IOException;
    }
}

