/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.xml;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.taglibs.standard.resources.Resources;
import org.apache.taglibs.standard.tag.common.core.Util;
import org.apache.taglibs.standard.util.XmlUtil;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;

public abstract class ParseSupport
extends BodyTagSupport {
    protected Object xml;
    protected String systemId;
    protected XMLFilter filter;
    private String var;
    private String varDom;
    private int scope;
    private int scopeDom;
    private XmlUtil.JstlEntityResolver entityResolver;

    public ParseSupport() {
        this.init();
    }

    private void init() {
        this.varDom = null;
        this.var = null;
        this.xml = null;
        this.systemId = null;
        this.filter = null;
        this.scope = 1;
        this.scopeDom = 1;
    }

    public int doEndTag() throws JspException {
        Object xmlText = this.xml;
        if (xmlText == null) {
            xmlText = this.bodyContent != null && this.bodyContent.getString() != null ? this.bodyContent.getString().trim() : "";
        }
        if (xmlText instanceof String) {
            xmlText = new StringReader((String)xmlText);
        }
        if (!(xmlText instanceof Reader)) {
            throw new JspTagException(Resources.getMessage("PARSE_INVALID_SOURCE"));
        }
        InputSource source = XmlUtil.newInputSource((Reader)xmlText, this.systemId);
        Document d = this.filter != null ? this.parseInputSourceWithFilter(source, this.filter) : this.parseInputSource(source);
        if (this.var != null) {
            this.pageContext.setAttribute(this.var, (Object)d, this.scope);
        }
        if (this.varDom != null) {
            this.pageContext.setAttribute(this.varDom, (Object)d, this.scopeDom);
        }
        return 6;
    }

    public void release() {
        this.init();
    }

    private Document parseInputSourceWithFilter(InputSource s, XMLFilter f) throws JspException {
        try {
            XMLReader xr = XmlUtil.newXMLReader(this.entityResolver);
            f.setParent(xr);
            TransformerHandler th = XmlUtil.newTransformerHandler();
            Document o = XmlUtil.newEmptyDocument();
            th.setResult(new DOMResult(o));
            f.setContentHandler(th);
            f.parse(s);
            return o;
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        catch (SAXException e) {
            throw new JspException((Throwable)e);
        }
        catch (TransformerConfigurationException e) {
            throw new JspException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new JspException((Throwable)e);
        }
    }

    private Document parseInputSource(InputSource s) throws JspException {
        try {
            DocumentBuilder db = XmlUtil.newDocumentBuilder();
            db.setEntityResolver(this.entityResolver);
            return db.parse(s);
        }
        catch (SAXException e) {
            throw new JspException((Throwable)e);
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
    }

    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
        this.entityResolver = pageContext == null ? null : new XmlUtil.JstlEntityResolver(pageContext);
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void setVarDom(String varDom) {
        this.varDom = varDom;
    }

    public void setScope(String scope) {
        this.scope = Util.getScope(scope);
    }

    public void setScopeDom(String scopeDom) {
        this.scopeDom = Util.getScope(scopeDom);
    }
}

