/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.components;

import org.apache.tapestry5.ComponentAction;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Field;
import org.apache.tapestry5.FieldValidationSupport;
import org.apache.tapestry5.FieldValidator;
import org.apache.tapestry5.RadioContainer;
import org.apache.tapestry5.ValidationException;
import org.apache.tapestry5.ValidationTracker;
import org.apache.tapestry5.ValueEncoder;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.commons.services.TypeCoercer;
import org.apache.tapestry5.http.services.Request;
import org.apache.tapestry5.internal.TapestryInternalUtils;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.ComponentDefaultProvider;
import org.apache.tapestry5.services.Environment;
import org.apache.tapestry5.services.FormSupport;

public class RadioGroup
implements Field {
    @Parameter(required=true, principal=true, autoconnect=true)
    private Object value;
    @Parameter(value="false")
    private boolean disabled;
    @Parameter(defaultPrefix="literal")
    private String label;
    @Parameter(value="prop:componentResources.id", defaultPrefix="literal")
    private String clientId;
    @Parameter(required=true, allowNull=false)
    private ValueEncoder encoder;
    @Parameter(defaultPrefix="validate")
    private FieldValidator<Object> validate;
    @Inject
    private ComponentDefaultProvider defaultProvider;
    @Inject
    private ComponentResources resources;
    @Environmental
    private FormSupport formSupport;
    @Inject
    private Environment environment;
    @Inject
    private Request request;
    @Inject
    private TypeCoercer typeCoercer;
    @Environmental
    private ValidationTracker tracker;
    @Inject
    private FieldValidationSupport fieldValidationSupport;
    private String controlName;
    private static final ComponentAction<RadioGroup> PROCESS_SUBMISSION = new ComponentAction<RadioGroup>(){
        private static final long serialVersionUID = -3857110108918776386L;

        @Override
        public void execute(RadioGroup component) {
            component.processSubmission();
        }

        public String toString() {
            return "RadioGroup.ProcessSubmission";
        }
    };

    String defaultLabel() {
        return this.defaultProvider.defaultLabel(this.resources);
    }

    final ValueEncoder defaultEncoder() {
        return this.defaultProvider.defaultValueEncoder("value", this.resources);
    }

    private void setup(String elementName) {
        this.controlName = elementName;
    }

    private void processSubmission() {
        if (this.disabled) {
            return;
        }
        String rawValue = this.request.getParameter(this.controlName);
        Object convertedValue = this.encoder.toValue(rawValue);
        this.tracker.recordInput(this, rawValue);
        try {
            if (this.validate != null) {
                this.fieldValidationSupport.validate(convertedValue, this.resources, this.validate);
            }
        }
        catch (ValidationException ex) {
            this.tracker.recordError(this, ex.getMessage());
        }
        this.value = convertedValue;
    }

    final void setupRender() {
        Setup action = new Setup(this.formSupport.allocateControlName(this.clientId));
        this.formSupport.storeAndExecute(this, action);
        String submittedValue = this.tracker.getInput(this);
        final String selectedValue = submittedValue != null ? submittedValue : this.encoder.toClient(this.value);
        final Class boundType = this.resources.getBoundType("value");
        this.environment.push(RadioContainer.class, new RadioContainer(){

            @Override
            public String getControlName() {
                return RadioGroup.this.controlName;
            }

            @Override
            public boolean isDisabled() {
                return RadioGroup.this.disabled;
            }

            private Object getObjectAsCorrectType(Object val) {
                if (val != null && boundType != null && !boundType.isAssignableFrom(val.getClass())) {
                    return RadioGroup.this.typeCoercer.coerce(val, boundType);
                }
                return val;
            }

            @Override
            public String toClient(Object value) {
                return RadioGroup.this.encoder.toClient(this.getObjectAsCorrectType(value));
            }

            @Override
            public boolean isSelected(Object value) {
                return TapestryInternalUtils.isEqual(RadioGroup.this.encoder.toClient(this.getObjectAsCorrectType(value)), selectedValue);
            }
        });
        this.formSupport.store(this, PROCESS_SUBMISSION);
    }

    final void afterRender() {
        this.environment.pop(RadioContainer.class);
    }

    @Override
    public String getControlName() {
        return this.controlName;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public String getClientId() {
        return null;
    }

    @Override
    public boolean isRequired() {
        return this.validate.isRequired();
    }

    private static class Setup
    implements ComponentAction<RadioGroup> {
        private static final long serialVersionUID = -7984673040135949374L;
        private final String controlName;

        Setup(String controlName) {
            this.controlName = controlName;
        }

        @Override
        public void execute(RadioGroup component) {
            component.setup(this.controlName);
        }

        public String toString() {
            return String.format("RadioGroup.Setup[%s]", this.controlName);
        }
    }
}

