/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import javax.wsdl.xml.WSDLLocator;
import org.apache.axis2.jaxws.catalog.JAXWSCatalogManager;
import org.apache.axis2.jaxws.util.BaseWSDLLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.resolver.Catalog;

public class CatalogWSDLLocator
extends BaseWSDLLocator
implements WSDLLocator {
    private static Log log = LogFactory.getLog(CatalogWSDLLocator.class);
    private Catalog catalogResolver;
    private ClassLoader classLoader;

    public CatalogWSDLLocator(String uri, InputStream stream, ClassLoader classLoader, JAXWSCatalogManager catalogManager) {
        this.baseURI = this.convertURI(uri);
        this.baseInputStream = stream;
        this.classLoader = classLoader;
        this.catalogResolver = catalogManager.getCatalog();
    }

    public String getRedirectedURI(String importURI, String parent) {
        String resolvedImportLocation = null;
        try {
            resolvedImportLocation = this.catalogResolver.resolveSystem(importURI);
            if (resolvedImportLocation == null) {
                resolvedImportLocation = this.catalogResolver.resolveURI(importURI);
            }
            if (resolvedImportLocation == null) {
                resolvedImportLocation = this.catalogResolver.resolvePublic(importURI, parent);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Catalog resolution failed", e);
        }
        return resolvedImportLocation;
    }

    protected InputStream getInputStream(String importPath) throws IOException {
        URL importURL = null;
        InputStream is = null;
        try {
            importURL = new URL(importPath);
            is = importURL.openStream();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (is == null) {
            try {
                is = this.classLoader.getResourceAsStream(importPath);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (is == null) {
            try {
                File file = new File(importPath);
                is = file.toURI().toURL().openStream();
            }
            catch (Throwable file) {
                // empty catch block
            }
        }
        if (is == null) {
            try {
                URI uri = new URI(importPath);
                is = uri.toURL().openStream();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return is;
    }

    public URL getWsdlUrl(String wsdlLocation) {
        URL streamURL = null;
        InputStream is = null;
        URI pathURI = null;
        try {
            streamURL = new URL(wsdlLocation);
            is = streamURL.openStream();
            is.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (is == null) {
            try {
                pathURI = new URI(wsdlLocation);
                streamURL = pathURI.toURL();
                is = streamURL.openStream();
                is.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (is == null) {
            try {
                File file = new File(wsdlLocation);
                streamURL = file.toURI().toURL();
                is = streamURL.openStream();
                is.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (log.isDebugEnabled() && streamURL == null) {
            log.debug((Object)("Absolute wsdlLocation could not be determined: " + wsdlLocation));
        }
        return streamURL;
    }

    public void close() {
    }
}

