/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru;

import org.apache.http.nio.NHttpConnection;
import org.apache.synapse.transport.passthru.Pipe;
import org.apache.synapse.transport.passthru.ProtocolState;
import org.apache.synapse.transport.passthru.SourceRequest;
import org.apache.synapse.transport.passthru.SourceResponse;
import org.apache.synapse.transport.passthru.config.SourceConfiguration;
import org.apache.synapse.transport.passthru.util.ControlledByteBuffer;

public class SourceContext {
    public static final String CONNECTION_INFORMATION = "CONNECTION_INFORMATION";
    private SourceConfiguration sourceConfiguration;
    private ProtocolState state = ProtocolState.REQUEST_READY;
    private SourceRequest request;
    private SourceResponse response;
    private boolean shutDown = false;
    private Pipe reader;
    private Pipe writer;

    public SourceContext(SourceConfiguration sourceConfiguration) {
        this.sourceConfiguration = sourceConfiguration;
    }

    public ProtocolState getState() {
        return this.state;
    }

    public void setState(ProtocolState state) {
        this.state = state;
    }

    public SourceRequest getRequest() {
        return this.request;
    }

    public void setRequest(SourceRequest request) {
        this.request = request;
    }

    public SourceResponse getResponse() {
        return this.response;
    }

    public void setResponse(SourceResponse response) {
        this.response = response;
    }

    public void reset() {
        this.reset(false);
    }

    public void reset(boolean isError) {
        this.request = null;
        this.response = null;
        if (this.state != ProtocolState.CLOSED) {
            this.state = ProtocolState.REQUEST_READY;
        }
        if (this.writer != null && !isError) {
            ControlledByteBuffer buffer = this.writer.getBuffer();
            buffer.clear();
            this.sourceConfiguration.getBufferFactory().release(buffer);
        }
        this.reader = null;
        this.writer = null;
    }

    public boolean isShutDown() {
        return this.shutDown;
    }

    public void setShutDown(boolean shutDown) {
        this.shutDown = shutDown;
    }

    public Pipe getReader() {
        return this.reader;
    }

    public void setReader(Pipe reader) {
        this.reader = reader;
    }

    public Pipe getWriter() {
        return this.writer;
    }

    public void setWriter(Pipe writer) {
        this.writer = writer;
    }

    public static void create(NHttpConnection conn, ProtocolState state, SourceConfiguration configuration) {
        SourceContext info = new SourceContext(configuration);
        conn.getContext().setAttribute(CONNECTION_INFORMATION, (Object)info);
        info.setState(state);
    }

    public static void updateState(NHttpConnection conn, ProtocolState state) {
        SourceContext info = (SourceContext)conn.getContext().getAttribute(CONNECTION_INFORMATION);
        if (info == null) {
            throw new IllegalStateException("Connection information should be present");
        }
        info.setState(state);
    }

    public static boolean assertState(NHttpConnection conn, ProtocolState state) {
        SourceContext info = (SourceContext)conn.getContext().getAttribute(CONNECTION_INFORMATION);
        return info != null && info.getState() == state;
    }

    public static ProtocolState getState(NHttpConnection conn) {
        SourceContext info = (SourceContext)conn.getContext().getAttribute(CONNECTION_INFORMATION);
        return info != null ? info.getState() : null;
    }

    public static void setRequest(NHttpConnection conn, SourceRequest request) {
        SourceContext info = (SourceContext)conn.getContext().getAttribute(CONNECTION_INFORMATION);
        if (info == null) {
            throw new IllegalStateException("Connection information should be present");
        }
        info.setRequest(request);
    }

    public static void setResponse(NHttpConnection conn, SourceResponse response) {
        SourceContext info = (SourceContext)conn.getContext().getAttribute(CONNECTION_INFORMATION);
        if (info == null) {
            throw new IllegalStateException("Connection information should be present");
        }
        info.setResponse(response);
    }

    public static SourceRequest getRequest(NHttpConnection conn) {
        SourceContext info = (SourceContext)conn.getContext().getAttribute(CONNECTION_INFORMATION);
        return info != null ? info.getRequest() : null;
    }

    public static SourceResponse getResponse(NHttpConnection conn) {
        SourceContext info = (SourceContext)conn.getContext().getAttribute(CONNECTION_INFORMATION);
        return info != null ? info.getResponse() : null;
    }

    public static SourceContext get(NHttpConnection conn) {
        return (SourceContext)conn.getContext().getAttribute(CONNECTION_INFORMATION);
    }
}

