/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.SSLContext;
import org.apache.axiom.blob.Blobs;
import org.apache.axiom.blob.OverflowableBlob;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingHelper;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.OutTransportInfo;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.transport.base.threads.NativeThreadFactory;
import org.apache.axis2.transport.base.threads.WorkerPool;
import org.apache.axis2.util.MessageProcessorSelector;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.NHttpClientEventHandler;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.nio.reactor.IOReactorExceptionHandler;
import org.apache.http.nio.reactor.ssl.SSLSetupHandler;
import org.apache.synapse.commons.jmx.MBeanRegistrar;
import org.apache.synapse.transport.nhttp.util.MessageFormatterDecoratorFactory;
import org.apache.synapse.transport.nhttp.util.NhttpUtil;
import org.apache.synapse.transport.passthru.ConnectCallback;
import org.apache.synapse.transport.passthru.DeliveryAgent;
import org.apache.synapse.transport.passthru.Pipe;
import org.apache.synapse.transport.passthru.ProtocolState;
import org.apache.synapse.transport.passthru.ServerWorker;
import org.apache.synapse.transport.passthru.SourceContext;
import org.apache.synapse.transport.passthru.SourceRequest;
import org.apache.synapse.transport.passthru.SourceResponse;
import org.apache.synapse.transport.passthru.TargetHandler;
import org.apache.synapse.transport.passthru.config.SourceConfiguration;
import org.apache.synapse.transport.passthru.config.TargetConfiguration;
import org.apache.synapse.transport.passthru.connections.TargetConnections;
import org.apache.synapse.transport.passthru.jmx.PassThroughTransportMetricsCollector;
import org.apache.synapse.transport.passthru.jmx.TransportView;
import org.apache.synapse.transport.passthru.util.PassThroughTransportUtils;
import org.apache.synapse.transport.passthru.util.SourceResponseFactory;
import org.apache.synapse.transport.utils.conn.logging.LoggingUtils;

public class PassThroughHttpSender
extends AbstractHandler
implements TransportSender {
    protected Log log = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());
    private DefaultConnectingIOReactor ioReactor;
    private DeliveryAgent deliveryAgent;
    private TargetConfiguration targetConfiguration;
    private volatile int state = 0;
    private String namePrefix;
    private String proxyHost = null;
    private int proxyPort = 80;
    private String[] proxyBypassList = new String[0];
    private List<String> knownDirectHosts = new ArrayList<String>();
    private List<String> knownProxyHosts = new ArrayList<String>();

    public void init(ConfigurationContext configurationContext, TransportOutDescription transportOutDescription) throws AxisFault {
        Parameter proxyHostParam;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Initializing pass-through HTTP/S sender...");
        }
        SSLContext sslContext = this.getSSLContext(transportOutDescription);
        SSLSetupHandler sslSetupHandler = this.getSSLSetupHandler(transportOutDescription);
        if (sslContext == null && ((proxyHostParam = transportOutDescription.getParameter("http.proxyHost")) != null || System.getProperty("http.proxyHost") != null)) {
            this.proxyHost = proxyHostParam != null ? (String)proxyHostParam.getValue() : System.getProperty("http.proxyHost");
            Parameter proxyPortParam = transportOutDescription.getParameter("http.proxyPort");
            if (proxyPortParam != null) {
                this.proxyPort = Integer.parseInt((String)proxyPortParam.getValue());
            } else if (System.getProperty("http.proxyPort") != null) {
                this.proxyPort = Integer.parseInt(System.getProperty("http.proxyPort"));
            }
            Parameter bypassList = transportOutDescription.getParameter("http.nonProxyHosts");
            if (bypassList != null) {
                this.proxyBypassList = ((String)bypassList.getValue()).split("\\|");
            } else if (System.getProperty("http.nonProxyHosts") != null) {
                this.proxyBypassList = System.getProperty("http.nonProxyHosts").split("\\|");
            }
            this.log.info((Object)("HTTP sender using Proxy : " + this.proxyHost + ":" + this.proxyPort + " bypassing : " + Arrays.toString(this.proxyBypassList)));
        }
        this.namePrefix = sslContext == null ? "HTTP" : "HTTPS";
        WorkerPool workerPool = null;
        Object obj = configurationContext.getProperty("PASS_THROUGH_TRANSPORT_WORKER_POOL");
        if (obj != null) {
            workerPool = (WorkerPool)obj;
        }
        this.targetConfiguration = new TargetConfiguration(configurationContext, (ParameterInclude)transportOutDescription, workerPool);
        configurationContext.setProperty("PASS_THROUGH_TRANSPORT_WORKER_POOL", (Object)this.targetConfiguration.getWorkerPool());
        PassThroughTransportMetricsCollector metrics = new PassThroughTransportMetricsCollector(false, sslContext != null);
        TransportView view = new TransportView(null, this, metrics, null);
        MBeanRegistrar.getInstance().registerMBean((Object)view, "Transport", "passthru-" + this.namePrefix.toLowerCase() + "-sender");
        this.targetConfiguration.setMetrics(metrics);
        try {
            String prefix = this.namePrefix + "-PT-Sender I/O Dispatcher";
            this.ioReactor = new DefaultConnectingIOReactor(this.targetConfiguration.getReactorConfig(false), (ThreadFactory)new NativeThreadFactory(new ThreadGroup(prefix + " Thread Group"), prefix));
            this.ioReactor.setExceptionHandler(new IOReactorExceptionHandler(){

                public boolean handle(IOException ioException) {
                    PassThroughHttpSender.this.log.warn((Object)("System may be unstable: " + PassThroughHttpSender.this.namePrefix + " ConnectingIOReactor encountered a checked exception : " + ioException.getMessage()), (Throwable)ioException);
                    return true;
                }

                public boolean handle(RuntimeException runtimeException) {
                    PassThroughHttpSender.this.log.warn((Object)("System may be unstable: " + PassThroughHttpSender.this.namePrefix + " ConnectingIOReactor encountered a runtime exception : " + runtimeException.getMessage()), (Throwable)runtimeException);
                    return true;
                }
            });
        }
        catch (IOReactorException e) {
            this.handleException("Error starting " + this.namePrefix + " ConnectingIOReactor", (Exception)((Object)e));
        }
        ConnectCallback connectCallback = new ConnectCallback();
        TargetConnections targetConnections = new TargetConnections((ConnectingIOReactor)this.ioReactor, this.targetConfiguration, connectCallback);
        this.targetConfiguration.setConnections(targetConnections);
        this.deliveryAgent = new DeliveryAgent(this.targetConfiguration, targetConnections);
        connectCallback.setDeliveryAgent(this.deliveryAgent);
        TargetHandler handler = new TargetHandler(this.deliveryAgent, this.targetConfiguration);
        final IOEventDispatch ioEventDispatch = this.getEventDispatch(handler, sslContext, sslSetupHandler, this.targetConfiguration.getConnectionConfig(), transportOutDescription);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    PassThroughHttpSender.this.ioReactor.execute(ioEventDispatch);
                }
                catch (Exception ex) {
                    PassThroughHttpSender.this.log.fatal((Object)("Exception encountered in the " + PassThroughHttpSender.this.namePrefix + " sender. No more connections will be initiated by this transport"), (Throwable)ex);
                }
                PassThroughHttpSender.this.log.info((Object)(PassThroughHttpSender.this.namePrefix + " sender shutdown"));
            }
        }, "PassThrough" + this.namePrefix + "Sender");
        t.start();
        this.state = 1;
        this.log.info((Object)("Pass-through " + this.namePrefix + " sender started..."));
    }

    public void cleanup(MessageContext messageContext) throws AxisFault {
    }

    public void stop() {
        try {
            this.ioReactor.shutdown();
        }
        catch (IOException e) {
            this.log.error((Object)"Error shutting down the PassThroughHttpSender", (Throwable)e);
        }
    }

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        EndpointReference epr;
        PassThroughTransportUtils.removeUnwantedHeaders(msgContext, this.targetConfiguration);
        if (AddressingHelper.isReplyRedirected((MessageContext)msgContext) && !msgContext.getReplyTo().hasNoneAddress()) {
            msgContext.setProperty("IGNORE_SC_ACCEPTED", (Object)"true");
        }
        if ((epr = PassThroughTransportUtils.getDestinationEPR(msgContext)) != null) {
            if (!epr.hasNoneAddress()) {
                if (msgContext.getProperty("pass-through.pipe") == null) {
                    Pipe pipe = new Pipe(this.targetConfiguration.getBufferFactory().getBuffer(), "Test", this.targetConfiguration);
                    msgContext.setProperty("pass-through.pipe", (Object)pipe);
                    msgContext.setProperty("message.builder.invoked", (Object)Boolean.TRUE);
                }
                try {
                    URL url = new URL(epr.getAddress());
                    String host = url.getHost();
                    int port = url.getPort();
                    if (port == -1) {
                        if ("http".equals(url.getProtocol())) {
                            port = 80;
                        } else if ("https".equals(url.getProtocol())) {
                            port = 443;
                        }
                    }
                    if (this.proxyHost != null) {
                        if (this.knownProxyHosts.contains(host)) {
                            host = this.proxyHost;
                            port = this.proxyPort;
                        } else if (!this.knownDirectHosts.contains(host) && !this.isBypass(host)) {
                            host = this.proxyHost;
                            port = this.proxyPort;
                        }
                    }
                    this.deliveryAgent.submit(msgContext, host, port);
                    this.sendRequestContent(msgContext);
                }
                catch (MalformedURLException e) {
                    this.handleException("Malformed URL in the target EPR", e);
                }
            } else {
                this.handleException("Cannot send message to http://www.w3.org/2005/08/addressing/none");
            }
        } else {
            if (msgContext.getProperty("OutTransportInfo") != null) {
                if (msgContext.getProperty("OutTransportInfo") instanceof ServerWorker) {
                    try {
                        this.submitResponse(msgContext);
                    }
                    catch (Exception e) {
                        this.handleException("Failed to submit the response", e);
                    }
                } else {
                    this.sendUsingOutputStream(msgContext);
                }
            } else {
                this.handleException("No valid destination EPR to send message");
            }
            if (msgContext.getOperationContext() != null) {
                msgContext.getOperationContext().setProperty("RESPONSE_WRITTEN", (Object)"true");
            }
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    private void sendUsingOutputStream(MessageContext msgContext) throws AxisFault {
        OMOutputFormat format = NhttpUtil.getOMOutputFormat(msgContext);
        MessageFormatter messageFormatter = MessageFormatterDecoratorFactory.createMessageFormatterDecorator(msgContext);
        OutputStream out = (OutputStream)msgContext.getProperty("TRANSPORT_OUT");
        if (msgContext.isServerSide()) {
            OutTransportInfo transportInfo = (OutTransportInfo)msgContext.getProperty("OutTransportInfo");
            if (transportInfo != null) {
                transportInfo.setContentType(messageFormatter.getContentType(msgContext, format, msgContext.getSoapAction()));
            } else {
                throw new AxisFault("OutTransportInfo has not been set");
            }
        }
        try {
            messageFormatter.writeTo(msgContext, format, out, false);
            out.close();
        }
        catch (IOException e) {
            this.handleException("IO Error sending response message", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRequestContent(MessageContext msgContext) throws AxisFault {
        boolean forceContentLength = msgContext.isPropertyTrue("FORCE_HTTP_CONTENT_LENGTH");
        boolean copyContentLength = msgContext.isPropertyTrue("COPY_CONTENT_LENGTH_FROM_INCOMING");
        if (forceContentLength && copyContentLength && msgContext.getProperty("ORIGINAL_CONTENT_LENGTH") != null) {
            long contentLength = Long.parseLong((String)msgContext.getProperty("ORIGINAL_CONTENT_LENGTH"));
            msgContext.setProperty("PASS_THROUGH_MESSAGE_LENGTH", (Object)contentLength);
        }
        if (Boolean.TRUE.equals(msgContext.getProperty("message.builder.invoked"))) {
            MessageContext contentLength = msgContext;
            synchronized (contentLength) {
                while (!Boolean.TRUE.equals(msgContext.getProperty("WAIT_BUILDER_IN_STREAM_COMPLETE")) && !Boolean.TRUE.equals(msgContext.getProperty("PASSTHRU_CONNECT_ERROR"))) {
                    try {
                        msgContext.wait();
                    }
                    catch (InterruptedException e) {
                        this.log.warn((Object)"Interrupted while waiting for message serialization to complete", (Throwable)e);
                    }
                }
            }
            if (Boolean.TRUE.equals(msgContext.getProperty("PASSTHRU_CONNECT_ERROR"))) {
                return;
            }
            OutputStream out = (OutputStream)msgContext.getProperty("BUILDER_OUTPUT_STREAM");
            if (out != null) {
                String disableChunking = (String)msgContext.getProperty("DISABLE_CHUNKING");
                String forceHttp10 = (String)msgContext.getProperty("FORCE_HTTP_1.0");
                Pipe pipe = (Pipe)msgContext.getProperty("pass-through.pipe");
                if ("true".equals(disableChunking) || "true".equals(forceHttp10)) {
                    MessageFormatter formatter = MessageProcessorSelector.getMessageFormatter((MessageContext)msgContext);
                    OMOutputFormat format = PassThroughTransportUtils.getOMOutputFormat(msgContext);
                    OverflowableBlob serialized = null;
                    try {
                        serialized = this.setStreamAsTempData(formatter, msgContext, format);
                        msgContext.setProperty("PASS_THROUGH_MESSAGE_LENGTH", (Object)serialized.getSize());
                        serialized.writeTo(out);
                    }
                    catch (IOException e) {
                        this.handleException("I/O error while serializing message", e);
                    }
                    finally {
                        if (serialized != null) {
                            try {
                                serialized.release();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    pipe.setSerializationComplete(true);
                } else {
                    if (disableChunking == null || !"true".equals(disableChunking) || forceHttp10 == null || !"true".equals(forceHttp10)) {
                        MessageFormatter formatter = MessageProcessorSelector.getMessageFormatter((MessageContext)msgContext);
                        OMOutputFormat format = PassThroughTransportUtils.getOMOutputFormat(msgContext);
                        formatter.writeTo(msgContext, format, out, false);
                    }
                    if (this.isCompleteWithoutData(msgContext)) {
                        pipe.setSerializationCompleteWithoutData(true);
                    } else {
                        pipe.setSerializationComplete(true);
                    }
                }
            }
        }
    }

    private boolean isCompleteWithoutData(MessageContext msgContext) {
        if (Boolean.TRUE.equals(msgContext.getProperty("rest_get_delete_invoke"))) {
            return true;
        }
        return Boolean.TRUE.equals(msgContext.getProperty("NO_ENTITY_BODY"));
    }

    protected IOEventDispatch getEventDispatch(NHttpClientEventHandler handler, SSLContext sslContext, SSLSetupHandler sslIOSessionHandler, ConnectionConfig config, TransportOutDescription trpOut) throws AxisFault {
        return LoggingUtils.getClientIODispatch(handler, config);
    }

    protected SSLContext getSSLContext(TransportOutDescription transportOut) throws AxisFault {
        return null;
    }

    protected SSLSetupHandler getSSLSetupHandler(TransportOutDescription transportOut) throws AxisFault {
        return null;
    }

    public void submitResponse(MessageContext msgContext) throws IOException, HttpException {
        ProtocolState state;
        Integer errorCode;
        SourceConfiguration sourceConfiguration = (SourceConfiguration)msgContext.getProperty("PASS_THROUGH_SOURCE_CONFIGURATION");
        NHttpServerConnection conn = (NHttpServerConnection)msgContext.getProperty("pass-through.Source-Connection");
        if (conn == null) {
            ServerWorker serverWorker = (ServerWorker)msgContext.getProperty("OutTransportInfo");
            if (serverWorker != null) {
                MessageContext requestContext = serverWorker.getRequestContext();
                conn = (NHttpServerConnection)requestContext.getProperty("pass-through.Source-Connection");
                sourceConfiguration = (SourceConfiguration)requestContext.getProperty("PASS_THROUGH_SOURCE_CONFIGURATION");
            } else {
                throw new IllegalStateException("Unable to correlate the response to a request");
            }
        }
        SourceRequest sourceRequest = SourceContext.getRequest((NHttpConnection)conn);
        SourceResponse sourceResponse = SourceResponseFactory.create(msgContext, sourceRequest, sourceConfiguration);
        sourceResponse.processChunkingOptions(msgContext);
        SourceContext.setResponse((NHttpConnection)conn, sourceResponse);
        Boolean noEntityBody = (Boolean)msgContext.getProperty("NO_ENTITY_BODY");
        Pipe pipe = (Pipe)msgContext.getProperty("pass-through.pipe");
        if (noEntityBody == null || !noEntityBody.booleanValue() || pipe != null) {
            if (pipe == null) {
                pipe = new Pipe(sourceConfiguration.getBufferFactory().getBuffer(), "Test", sourceConfiguration);
                msgContext.setProperty("pass-through.pipe", (Object)pipe);
                msgContext.setProperty("message.builder.invoked", (Object)Boolean.TRUE);
            }
            pipe.attachConsumer((IOControl)conn);
            sourceResponse.connect(pipe);
        }
        if ((errorCode = (Integer)msgContext.getProperty("ERROR_CODE")) != null) {
            sourceResponse.setStatus(502);
            SourceContext.get((NHttpConnection)conn).setShutDown(true);
        }
        if ((state = SourceContext.getState((NHttpConnection)conn)) != null && state.compareTo(ProtocolState.REQUEST_DONE) <= 0) {
            if (noEntityBody != null && Boolean.TRUE == noEntityBody && pipe != null) {
                OutputStream out = pipe.getOutputStream();
                out.write(new byte[0]);
                pipe.setRawSerializationComplete(true);
                out.close();
            } else if (msgContext.isPropertyTrue("message.builder.invoked") && pipe != null) {
                OutputStream out = pipe.getOutputStream();
                if (msgContext.isPropertyTrue("SC_ACCEPTED")) {
                    out.write(new byte[0]);
                } else {
                    MessageFormatter formatter = MessageProcessorSelector.getMessageFormatter((MessageContext)msgContext);
                    OMOutputFormat format = PassThroughTransportUtils.getOMOutputFormat(msgContext);
                    formatter.writeTo(msgContext, format, out, false);
                }
                pipe.setSerializationComplete(true);
                out.close();
            }
            conn.requestOutput();
        } else {
            if (errorCode != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.warn((Object)("A source connection is closed because of an error in target: " + conn));
                }
            } else {
                this.log.debug((Object)("A source connection is closed, because source handler is already in the process of writing a response while another response is submitted: " + conn));
            }
            SourceContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
            sourceConfiguration.getSourceConnections().shutDownConnection(conn, true);
        }
    }

    public void pause() throws AxisFault {
        if (this.state != 1) {
            return;
        }
        this.state = 2;
        this.log.info((Object)(this.namePrefix + " Sender Paused"));
    }

    public void resume() throws AxisFault {
        if (this.state != 2) {
            return;
        }
        this.state = 1;
        this.log.info((Object)(this.namePrefix + " Sender Resumed"));
    }

    public void maintenanceShutdown(long millis) throws AxisFault {
        if (this.state != 1) {
            return;
        }
        try {
            long start = System.currentTimeMillis();
            this.ioReactor.shutdown(millis);
            this.state = 0;
            this.log.info((Object)("Sender shutdown in : " + (System.currentTimeMillis() - start) / 1000L + "s"));
        }
        catch (IOException e) {
            this.handleException("Error shutting down the IOReactor for maintenance", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OverflowableBlob setStreamAsTempData(MessageFormatter messageFormatter, MessageContext msgContext, OMOutputFormat format) throws IOException {
        OverflowableBlob serialized = Blobs.createOverflowableBlob((int)4096, (String)"http-nio_", (String)".dat", (File)FileUtils.getTempDirectory());
        try (OutputStream out = serialized.getOutputStream();){
            messageFormatter.writeTo(msgContext, format, out, true);
        }
        return serialized;
    }

    private boolean isBypass(String hostName) {
        for (String entry : this.proxyBypassList) {
            if (!hostName.matches(entry)) continue;
            this.knownDirectHosts.add(hostName);
            return true;
        }
        this.knownProxyHosts.add(hostName);
        return false;
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        this.log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }

    private void handleException(String msg) throws AxisFault {
        this.log.error((Object)msg);
        throw new AxisFault(msg);
    }
}

