/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.datasource.serializer;

import java.util.Map;
import java.util.Properties;
import org.apache.synapse.commons.datasource.DataSourceInformation;
import org.apache.synapse.securevault.secret.SecretInformation;

public class DataSourceInformationSerializer {
    public static Properties serialize(DataSourceInformation information) {
        Properties properties = new Properties();
        String alias = information.getAlias();
        StringBuffer buffer = new StringBuffer();
        buffer.append("synapse.datasources");
        buffer.append(".");
        buffer.append(alias);
        buffer.append(".");
        String prefix = buffer.toString();
        DataSourceInformationSerializer.addProperty(properties, prefix + "dsName", information.getDatasourceName());
        SecretInformation secretInformation = information.getSecretInformation();
        if (secretInformation != null) {
            String password;
            String user = secretInformation.getUser();
            if (user != null && !"".equals(user)) {
                DataSourceInformationSerializer.addProperty(properties, prefix + "username", user);
            }
            if ((password = secretInformation.getAliasSecret()) != null && !"".equals(password)) {
                DataSourceInformationSerializer.addProperty(properties, prefix + "password", password);
            }
        }
        DataSourceInformationSerializer.addProperty(properties, prefix + "maxActive", String.valueOf(information.getMaxActive()));
        DataSourceInformationSerializer.addProperty(properties, prefix + "maxIdle", String.valueOf(information.getMaxIdle()));
        DataSourceInformationSerializer.addProperty(properties, prefix + "maxWait", String.valueOf(information.getMaxWait()));
        DataSourceInformationSerializer.addProperty(properties, prefix + "driverClassName", String.valueOf(information.getDriver()));
        DataSourceInformationSerializer.addProperty(properties, prefix + "url", String.valueOf(information.getUrl()));
        DataSourceInformationSerializer.addProperty(properties, prefix + "type", String.valueOf(information.getType()));
        DataSourceInformationSerializer.addProperty(properties, prefix + "defaultAutoCommit", String.valueOf(information.isDefaultAutoCommit()));
        DataSourceInformationSerializer.addProperty(properties, prefix + "defaultReadOnly", String.valueOf(information.isDefaultReadOnly()));
        DataSourceInformationSerializer.addProperty(properties, prefix + "testOnBorrow", String.valueOf(information.isTestOnBorrow()));
        DataSourceInformationSerializer.addProperty(properties, prefix + "testOnReturn", String.valueOf(information.isTestOnReturn()));
        DataSourceInformationSerializer.addProperty(properties, prefix + "minIdle", String.valueOf(information.getMinIdle()));
        DataSourceInformationSerializer.addProperty(properties, prefix + "initialSize", String.valueOf(information.getInitialSize()));
        DataSourceInformationSerializer.addProperty(properties, prefix + "defaultTransactionIsolation", String.valueOf(information.getDefaultTransactionIsolation()));
        String defaultCatalog = information.getDefaultCatalog();
        if (defaultCatalog != null && !"".equals(defaultCatalog)) {
            DataSourceInformationSerializer.addProperty(properties, prefix + "defaultCatalog", String.valueOf(defaultCatalog));
        }
        DataSourceInformationSerializer.addProperty(properties, prefix + "accessToUnderlyingConnectionAllowed", String.valueOf(information.isAccessToUnderlyingConnectionAllowed()));
        DataSourceInformationSerializer.addProperty(properties, prefix + "removeAbandoned", String.valueOf(information.isRemoveAbandoned()));
        DataSourceInformationSerializer.addProperty(properties, prefix + "removeAbandonedTimeout", String.valueOf(information.getRemoveAbandonedTimeout()));
        DataSourceInformationSerializer.addProperty(properties, prefix + "logAbandoned", String.valueOf(information.isLogAbandoned()));
        DataSourceInformationSerializer.addProperty(properties, prefix + "poolPreparedStatements", String.valueOf(information.isPoolPreparedStatements()));
        DataSourceInformationSerializer.addProperty(properties, prefix + "maxOpenPreparedStatements", String.valueOf(information.getMaxOpenPreparedStatements()));
        DataSourceInformationSerializer.addProperty(properties, prefix + "registry", String.valueOf(information.getRepositoryType()));
        DataSourceInformationSerializer.addProperty(properties, prefix + "timeBetweenEvictionRunsMillis", String.valueOf(information.getTimeBetweenEvictionRunsMillis()));
        DataSourceInformationSerializer.addProperty(properties, prefix + "numTestsPerEvictionRun", String.valueOf(information.getNumTestsPerEvictionRun()));
        DataSourceInformationSerializer.addProperty(properties, prefix + "minEvictableIdleTimeMillis", String.valueOf(information.getMinEvictableIdleTimeMillis()));
        DataSourceInformationSerializer.addProperty(properties, prefix + "testWhileIdle", String.valueOf(information.isTestWhileIdle()));
        String validationQ = information.getValidationQuery();
        if (validationQ != null && !"".equals(validationQ)) {
            DataSourceInformationSerializer.addProperty(properties, prefix + "validationQuery", String.valueOf(validationQ));
        }
        properties.putAll(information.getAllParameters());
        properties.putAll((Map<?, ?>)information.getProperties());
        return properties;
    }

    private static void addProperty(Properties properties, String key, String value) {
        if (value != null && !"".equals(value)) {
            properties.setProperty(key, value);
        }
    }
}

