/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.bean;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.axis2.databinding.typemapping.SimpleTypeMapper;
import org.apache.synapse.SynapseException;

public class BeanUtils {
    private BeanUtils() {
    }

    public static Object invokeInstanceMethod(Object instance, Method method, Object[] args) throws SynapseException {
        Class<?>[] paramTypes = method.getParameterTypes();
        if (paramTypes.length != args.length) {
            throw new SynapseException("Provided argument count does not match method the parameter count of method '" + method.getName() + "'. Argument count = " + args.length + ", method parameter count = " + paramTypes.length + ".");
        }
        Object[] processedArgs = new Object[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            if (args[i] == null || paramTypes[i].isAssignableFrom(args[i].getClass())) {
                processedArgs[i] = args[i];
                continue;
            }
            if (SimpleTypeMapper.isSimpleType(paramTypes[i])) {
                processedArgs[i] = SimpleTypeMapper.getSimpleTypeObject(paramTypes[i], (String)args[i].toString());
                continue;
            }
            throw new SynapseException("Incompatible argument found in argument " + i + " for '" + method.getName() + "' method.");
        }
        try {
            return method.invoke(instance, processedArgs);
        }
        catch (IllegalAccessException e) {
            throw new SynapseException("Error while invoking '" + method.getName() + "' method via reflection.", e);
        }
        catch (InvocationTargetException e) {
            throw new SynapseException("Error while invoking '" + method.getName() + "' method via reflection.", e);
        }
    }

    public static Method resolveMethod(Class clazz, String methodName, int argCount) throws SynapseException {
        Method resolvedMethod = null;
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(methodName) || method.getParameterTypes().length != argCount) continue;
            if (resolvedMethod == null) {
                resolvedMethod = method;
                continue;
            }
            throw new SynapseException("More than one '" + methodName + "' methods taking " + argCount + " arguments are found in '" + clazz.getName() + "' class.");
        }
        return resolvedMethod;
    }
}

