/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.apache.synapse.config.xml.SynapseXPathFactory;
import org.apache.synapse.mediators.transform.HeaderMediator;
import org.jaxen.JaxenException;

public class HeaderMediatorFactory
extends AbstractMediatorFactory {
    private static final QName HEADER_Q = new QName("http://ws.apache.org/ns/synapse", "header");
    private static final QName ATT_ACTION = new QName("action");
    private static final QName ATT_SCOPE = new QName("scope");

    @Override
    public Mediator createSpecificMediator(OMElement elem, Properties properties) {
        HeaderMediator headerMediator = new HeaderMediator();
        OMAttribute name = elem.getAttribute(ATT_NAME);
        OMAttribute value = elem.getAttribute(ATT_VALUE);
        OMAttribute exprn = elem.getAttribute(ATT_EXPRN);
        OMAttribute action = elem.getAttribute(ATT_ACTION);
        OMAttribute scope = elem.getAttribute(ATT_SCOPE);
        if (name == null || name.getAttributeValue() == null) {
            if (!this.isEmbeddedXML(elem)) {
                this.handleException("A valid name attribute is required for the header mediator");
            }
        } else if (scope == null) {
            String nameAtt = name.getAttributeValue();
            if ("To".equals(nameAtt) || "From".equals(nameAtt) || "Action".equals(nameAtt) || "FaultTo".equals(nameAtt) || "ReplyTo".equals(nameAtt) || "RelatesTo".equals(nameAtt)) {
                headerMediator.setQName(new QName(nameAtt));
            } else {
                this.setSOAPHeader(headerMediator, elem, name);
            }
        } else {
            String scopeAttValue = scope.getAttributeValue();
            if ("soap".equalsIgnoreCase(scopeAttValue)) {
                this.setSOAPHeader(headerMediator, elem, name);
            } else if ("transport".equalsIgnoreCase(scopeAttValue)) {
                headerMediator.setQName(new QName(name.getAttributeValue()));
            } else {
                this.handleException("Unsupported Scope : " + scopeAttValue + " . Only " + "soap" + " and " + "transport" + " allowed");
            }
            headerMediator.setScope(scopeAttValue);
        }
        this.processAuditStatus(headerMediator, elem);
        if (action != null && "remove".equals(action.getAttributeValue())) {
            headerMediator.setAction(1);
        }
        if (headerMediator.getAction() == 0 && value == null && exprn == null && !headerMediator.isImplicit()) {
            this.handleException("A 'value' or 'expression' attribute is required for a [set] header mediator");
        }
        if (value != null && value.getAttributeValue() != null) {
            headerMediator.setValue(value.getAttributeValue());
        } else if (exprn != null && exprn.getAttributeValue() != null) {
            try {
                headerMediator.setExpression(SynapseXPathFactory.getSynapseXPath(elem, ATT_EXPRN));
            }
            catch (JaxenException je) {
                this.handleException("Invalid XPath expression : " + exprn.getAttributeValue());
            }
        } else if (headerMediator.isImplicit()) {
            Iterator i = elem.getChildElements();
            if (i == null) {
                this.handleException("A non standard header with both value and expression null must contain an embedded XML definition.");
                return null;
            }
            while (i.hasNext()) {
                headerMediator.addEmbeddedXml((OMElement)i.next());
            }
        }
        return headerMediator;
    }

    private void setSOAPHeader(HeaderMediator headerMediator, OMElement elem, OMAttribute name) {
        String nameAtt = name.getAttributeValue();
        QName qname = elem.resolveQName(nameAtt);
        if (qname == null) {
            this.handleException("Invalid QName '" + nameAtt + "' in name attribute");
        } else if (qname.getNamespaceURI().isEmpty()) {
            this.handleException("Invalid SOAP header: " + nameAtt + " specified at the header mediator. All SOAP headers must be namespace qualified.");
        } else {
            headerMediator.setQName(qname);
        }
    }

    private boolean isEmbeddedXML(OMElement elem) {
        return elem.getChildElements() != null && elem.getChildElements().hasNext();
    }

    @Override
    public QName getTagQName() {
        return HEADER_Q;
    }
}

