/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.signature.validator;

import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.signature.PGPData;
import org.opensaml.xml.signature.PGPKeyID;
import org.opensaml.xml.signature.PGPKeyPacket;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PGPDataSchemaValidator
implements Validator<PGPData> {
    private static final Set<QName> VALID_DS_CHILD_NAMES = new HashSet<QName>(5);

    @Override
    public void validate(PGPData xmlObject) throws ValidationException {
        this.validateChildrenPresence(xmlObject);
        this.validateChildrenNamespaces(xmlObject);
    }

    protected static Set<QName> getValidDSChildNames() {
        return VALID_DS_CHILD_NAMES;
    }

    protected void validateChildrenPresence(PGPData xmlObject) throws ValidationException {
        if (xmlObject.getPGPKeyID() == null && xmlObject.getPGPKeyPacket() == null) {
            throw new ValidationException("PGPData must contain at least one of PGPKeyID or PGPKeyPacket");
        }
    }

    protected void validateChildrenNamespaces(PGPData xmlObject) throws ValidationException {
        for (XMLObject child : xmlObject.getUnknownXMLObjects()) {
            QName childName = child.getElementQName();
            if (PGPDataSchemaValidator.getValidDSChildNames().contains(childName) || !"http://www.w3.org/2000/09/xmldsig#".equals(childName.getNamespaceURI())) continue;
            throw new ValidationException("PGPData contains an illegal child extension element: " + childName);
        }
    }

    static {
        VALID_DS_CHILD_NAMES.add(PGPKeyID.DEFAULT_ELEMENT_NAME);
        VALID_DS_CHILD_NAMES.add(PGPKeyPacket.DEFAULT_ELEMENT_NAME);
    }
}

