/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru.util;

import java.net.InetAddress;
import java.util.Iterator;
import java.util.Map;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.TransportUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpResponse;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.synapse.transport.passthru.ProtocolState;
import org.apache.synapse.transport.passthru.SourceContext;
import org.apache.synapse.transport.passthru.TargetContext;
import org.apache.synapse.transport.passthru.config.TargetConfiguration;
import org.apache.synapse.transport.passthru.connections.SourceConnections;
import org.apache.synapse.transport.passthru.connections.TargetConnections;
import org.apache.synapse.transport.utils.conn.SynapseNHttpClientConnection;

public class PassThroughTransportUtils {
    private static final Log log = LogFactory.getLog(PassThroughTransportUtils.class);
    private static final ConnectionReuseStrategy connStrategy = new DefaultConnectionReuseStrategy();

    public static String getHostName(InetAddress address) {
        String hostAddress = address.getHostAddress();
        String inetAddr = address.toString();
        int index1 = inetAddr.lastIndexOf(47);
        int index2 = inetAddr.indexOf(hostAddress);
        String result = index2 == index1 + 1 ? (index1 == 0 ? hostAddress : inetAddr.substring(0, index1)) : hostAddress;
        return result;
    }

    public static EndpointReference getDestinationEPR(MessageContext msgContext) {
        String transportURL = (String)msgContext.getProperty("TransportURL");
        if (transportURL != null) {
            return new EndpointReference(transportURL);
        }
        if (msgContext.getTo() != null && !msgContext.getTo().hasAnonymousAddress()) {
            return msgContext.getTo();
        }
        return null;
    }

    public static void removeUnwantedHeaders(MessageContext msgContext, TargetConfiguration targetConfiguration) {
        Map headers = (Map)msgContext.getProperty("TRANSPORT_HEADERS");
        Map excessHeaders = (Map)msgContext.getProperty("EXCESS_TRANSPORT_HEADERS");
        if (headers == null || headers.isEmpty()) {
            return;
        }
        Iterator iter = headers.keySet().iterator();
        while (iter.hasNext()) {
            String headerName = (String)iter.next();
            if ("Connection".equalsIgnoreCase(headerName) || "Transfer-Encoding".equalsIgnoreCase(headerName)) {
                iter.remove();
            }
            if ("Date".equalsIgnoreCase(headerName) && !targetConfiguration.isPreserveHttpHeader("Date")) {
                iter.remove();
            }
            if ("Content-Length".equalsIgnoreCase(headerName) && !targetConfiguration.isPreserveHttpHeader("Content-Length")) {
                iter.remove();
            }
            if ("Keep-Alive".equalsIgnoreCase(headerName) && !targetConfiguration.isPreserveHttpHeader("Keep-Alive")) {
                iter.remove();
            }
            if ("Server".equalsIgnoreCase(headerName) && !targetConfiguration.isPreserveHttpHeader("Server")) {
                iter.remove();
            }
            if (!"User-Agent".equalsIgnoreCase(headerName) || targetConfiguration.isPreserveHttpHeader("User-Agent")) continue;
            iter.remove();
        }
    }

    public static int determineHttpStatusCode(MessageContext msgContext) {
        int httpStatus = 200;
        if (msgContext.isPropertyTrue("SC_ACCEPTED")) {
            httpStatus = 202;
        } else {
            Object statusCode;
            boolean handleFault = msgContext.getEnvelope() != null && (msgContext.getEnvelope().getBody().hasFault() || msgContext.isProcessingFault());
            boolean faultsAsHttp200 = "TRUE".equals(msgContext.getProperty("FAULTS_AS_HTTP_200"));
            if (handleFault && !faultsAsHttp200) {
                httpStatus = 500;
            }
            if ((statusCode = msgContext.getProperty("HTTP_SC")) != null) {
                try {
                    httpStatus = Integer.parseInt(msgContext.getProperty("HTTP_SC").toString());
                }
                catch (NumberFormatException e) {
                    log.warn((Object)("Unable to set the HTTP status code from the property HTTP_SC with value: " + statusCode));
                }
            }
        }
        return httpStatus;
    }

    public static OMOutputFormat getOMOutputFormat(MessageContext msgContext) {
        OMOutputFormat format = msgContext.getProperty("MESSAGE_OUTPUT_FORMAT") != null ? (OMOutputFormat)msgContext.getProperty("MESSAGE_OUTPUT_FORMAT") : new OMOutputFormat();
        msgContext.setDoingMTOM(TransportUtils.doWriteMTOM((MessageContext)msgContext));
        msgContext.setDoingSwA(TransportUtils.doWriteSwA((MessageContext)msgContext));
        msgContext.setDoingREST(TransportUtils.isDoingREST((MessageContext)msgContext));
        format.setSOAP11(msgContext.isSOAP11());
        format.setDoOptimize(msgContext.isDoingMTOM());
        format.setDoingSWA(msgContext.isDoingSwA());
        format.setCharSetEncoding(TransportUtils.getCharSetEncoding((MessageContext)msgContext));
        Object mimeBoundaryProperty = msgContext.getProperty("mimeBoundary");
        if (mimeBoundaryProperty != null) {
            format.setMimeBoundary((String)mimeBoundaryProperty);
        }
        return format;
    }

    public static boolean builderInvoked(MessageContext messageContext) {
        return Boolean.TRUE.equals(messageContext.getProperty("message.builder.invoked"));
    }

    public static void finishUsingSourceConnection(HttpResponse response, NHttpServerConnection conn, SourceConnections connections) {
        if (!connStrategy.keepAlive(response, conn.getContext()) || SourceContext.get((NHttpConnection)conn).isShutDown()) {
            SourceContext.updateState((NHttpConnection)conn, ProtocolState.CLOSING);
            connections.closeConnection(conn);
        } else {
            connections.releaseConnection(conn);
            conn.requestInput();
        }
    }

    public static void finishUsingTargetConnection(HttpResponse response, NHttpClientConnection conn, TargetConnections connections) {
        if (!connStrategy.keepAlive(response, conn.getContext())) {
            TargetContext.updateState((NHttpConnection)conn, ProtocolState.CLOSING);
            connections.closeConnection(conn);
        } else if (conn instanceof SynapseNHttpClientConnection) {
            ((SynapseNHttpClientConnection)conn).markForRelease();
        } else {
            connections.releaseConnection(conn);
        }
    }
}

