/*
 * Decompiled with CFR 0.152.
 */
package javax.script;

import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.SimpleBindings;

public class SimpleScriptContext
implements ScriptContext {
    protected Bindings globalScope = null;
    protected Bindings engineScope = new SimpleBindings();
    protected Reader reader = new InputStreamReader(System.in);
    protected Writer writer = new PrintWriter(System.out, true);
    protected Writer errorWriter = new PrintWriter(System.err, true);
    private static final List SCOPES = Collections.unmodifiableList(Arrays.asList(new Integer(100), new Integer(200)));

    private void checkName(String name) {
        if (name == null) {
            throw new NullPointerException("name must not be null");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("name must not be an empty string");
        }
    }

    public Object getAttribute(String name) {
        this.checkName(name);
        Object engineObject = this.engineScope.get(name);
        if (engineObject != null) {
            return engineObject;
        }
        if (this.globalScope != null) {
            return this.globalScope.get(name);
        }
        return null;
    }

    public Object getAttribute(String name, int scope) {
        this.checkName(name);
        switch (scope) {
            case 100: {
                return this.engineScope.get(name);
            }
            case 200: {
                return this.globalScope != null ? this.globalScope.get(name) : null;
            }
        }
        throw new IllegalArgumentException("invalid scope");
    }

    public int getAttributesScope(String name) {
        this.checkName(name);
        if (this.engineScope.containsKey(name)) {
            return 100;
        }
        if (this.globalScope != null && this.globalScope.containsKey(name)) {
            return 200;
        }
        return -1;
    }

    public Bindings getBindings(int scope) {
        switch (scope) {
            case 100: {
                return this.engineScope;
            }
            case 200: {
                return this.globalScope;
            }
        }
        throw new IllegalArgumentException("invalid scope");
    }

    public Object removeAttribute(String name, int scope) {
        this.checkName(name);
        switch (scope) {
            case 100: {
                return this.engineScope.remove(name);
            }
            case 200: {
                return this.globalScope != null ? this.globalScope.remove(name) : null;
            }
        }
        throw new IllegalArgumentException("invalid scope");
    }

    public void setAttribute(String name, Object value, int scope) {
        this.checkName(name);
        switch (scope) {
            case 100: {
                this.engineScope.put(name, value);
                break;
            }
            case 200: {
                if (this.globalScope == null) break;
                this.globalScope.put(name, value);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid scope");
            }
        }
    }

    public void setBindings(Bindings bindings, int scope) {
        switch (scope) {
            case 100: {
                if (bindings == null) {
                    throw new NullPointerException("binding is null for ENGINE_SCOPE scope");
                }
                this.engineScope = bindings;
                break;
            }
            case 200: {
                this.globalScope = bindings;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid scope");
            }
        }
    }

    public List getScopes() {
        return SCOPES;
    }

    public Reader getReader() {
        return this.reader;
    }

    public void setReader(Reader reader) {
        this.reader = reader;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public Writer getErrorWriter() {
        return this.errorWriter;
    }

    public void setErrorWriter(Writer writer) {
        this.errorWriter = writer;
    }
}

