/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.flink.core;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.types.Row;
import org.apache.streampark.common.conf.ConfigConst$;
import org.apache.streampark.common.util.Logger;
import org.apache.streampark.flink.core.SqlCommand;
import org.apache.streampark.flink.core.SqlCommand$BEGIN_STATEMENT_SET$;
import org.apache.streampark.flink.core.SqlCommand$DELETE$;
import org.apache.streampark.flink.core.SqlCommand$DESC$;
import org.apache.streampark.flink.core.SqlCommand$DESCRIBE$;
import org.apache.streampark.flink.core.SqlCommand$END_STATEMENT_SET$;
import org.apache.streampark.flink.core.SqlCommand$EXPLAIN$;
import org.apache.streampark.flink.core.SqlCommand$INSERT$;
import org.apache.streampark.flink.core.SqlCommand$RESET$;
import org.apache.streampark.flink.core.SqlCommand$RESET_ALL$;
import org.apache.streampark.flink.core.SqlCommand$SELECT$;
import org.apache.streampark.flink.core.SqlCommand$SET$;
import org.apache.streampark.flink.core.SqlCommand$SHOW_CATALOGS$;
import org.apache.streampark.flink.core.SqlCommand$SHOW_CURRENT_CATALOG$;
import org.apache.streampark.flink.core.SqlCommand$SHOW_CURRENT_DATABASE$;
import org.apache.streampark.flink.core.SqlCommand$SHOW_DATABASES$;
import org.apache.streampark.flink.core.SqlCommand$SHOW_FUNCTIONS$;
import org.apache.streampark.flink.core.SqlCommand$SHOW_MODULES$;
import org.apache.streampark.flink.core.SqlCommand$SHOW_TABLES$;
import org.apache.streampark.flink.core.SqlCommand$UPDATE$;
import org.apache.streampark.flink.core.SqlCommandCall;
import org.apache.streampark.flink.core.SqlCommandParser$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Try$;

public final class FlinkSqlExecutor$
implements Logger {
    public static FlinkSqlExecutor$ MODULE$;
    private final ReentrantReadWriteLock.WriteLock lock;
    private transient org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger;
    private final String org$apache$streampark$common$util$Logger$$prefix;

    static {
        new FlinkSqlExecutor$();
    }

    @Override
    public String logName() {
        return Logger.logName$(this);
    }

    @Override
    public org.apache.streampark.shaded.org.slf4j.Logger logger() {
        return Logger.logger$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logger.logInfo$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logger.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logger.logDebug$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logger.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logger.logTrace$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logger.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarn(Function0<String> msg) {
        Logger.logWarn$(this, msg);
    }

    @Override
    public void logWarn(Function0<String> msg, Throwable throwable) {
        Logger.logWarn$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logger.logError$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logger.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logger.isTraceEnabled$(this);
    }

    @Override
    public org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger() {
        return this.org$apache$streampark$common$util$Logger$$_logger;
    }

    @Override
    public void org$apache$streampark$common$util$Logger$$_logger_$eq(org.apache.streampark.shaded.org.slf4j.Logger x$1) {
        this.org$apache$streampark$common$util$Logger$$_logger = x$1;
    }

    @Override
    public String org$apache$streampark$common$util$Logger$$prefix() {
        return this.org$apache$streampark$common$util$Logger$$prefix;
    }

    @Override
    public final void org$apache$streampark$common$util$Logger$_setter_$org$apache$streampark$common$util$Logger$$prefix_$eq(String x$1) {
        this.org$apache$streampark$common$util$Logger$$prefix = x$1;
    }

    public void executeSql(String sql, ParameterTool parameter, TableEnvironment context, Function1<String, BoxedUnit> callbackFunc) {
        String flinkSql = StringUtils.isBlank((CharSequence)sql) ? parameter.get(ConfigConst$.MODULE$.KEY_FLINK_SQL(ConfigConst$.MODULE$.KEY_FLINK_SQL$default$1())) : parameter.get(sql);
        Predef$.MODULE$.require(StringUtils.isNotBlank((CharSequence)flinkSql), (Function0 & Serializable & scala.Serializable)() -> "verify failed: flink sql cannot be empty");
        String runMode = parameter.get(ExecutionOptions.RUNTIME_MODE.key());
        BooleanRef hasInsert = BooleanRef.create((boolean)false);
        StatementSet statementSet = context.createStatementSet();
        SqlCommandParser$.MODULE$.parseSQL(flinkSql, SqlCommandParser$.MODULE$.parseSQL$default$2()).foreach((Function1 & Serializable & scala.Serializable)x -> {
            FlinkSqlExecutor$.$anonfun$executeSql$3(this, context, statementSet, hasInsert, runMode, callbackFunc, x);
            return BoxedUnit.UNIT;
        });
        if (hasInsert.elem) {
            TableResult tableResult = statementSet.execute();
            if (tableResult != null) {
                JobID jobID = (JobID)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> ((JobClient)tableResult.getJobClient().get()).getJobID()).getOrElse((Function0 & Serializable & scala.Serializable)() -> null);
                if (jobID != null) {
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(6).append("jobId:").append(jobID).toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "No 'INSERT' statement to trigger the execution of the Flink job.");
            throw new RuntimeException("No 'INSERT' statement to trigger the execution of the Flink job.");
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(75).append("\n\n\n==============flinkSql==============\n\n ").append(flinkSql).append("\n\n============================\n\n\n").toString());
    }

    public Function1<String, BoxedUnit> executeSql$default$4(String sql, ParameterTool parameter, TableEnvironment context) {
        return null;
    }

    private final void callback$1(String r, Function1 callbackFunc$1) {
        Function1 function1 = callbackFunc$1;
        if (function1 == null) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> r);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = (BoxedUnit)function1.apply((Object)r);
        }
    }

    public static final /* synthetic */ boolean $anonfun$executeSql$4(String x$1) {
        return !x$1.startsWith("UnnamedTable");
    }

    public static final /* synthetic */ void $anonfun$executeSql$3(FlinkSqlExecutor$ $this, TableEnvironment context$1, StatementSet statementSet$1, BooleanRef hasInsert$1, String runMode$1, Function1 callbackFunc$1, SqlCommandCall x) {
        String args = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x.operands())).isEmpty() ? null : (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x.operands())).head();
        String command = x.command().name();
        SqlCommand sqlCommand = x.command();
        if (SqlCommand$SHOW_CATALOGS$.MODULE$.equals(sqlCommand)) {
            String[] catalogs = context$1.listCatalogs();
            $this.callback$1(new java.lang.StringBuilder(2).append(command).append(": ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])catalogs)).mkString("\n")).toString(), callbackFunc$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (SqlCommand$SHOW_CURRENT_CATALOG$.MODULE$.equals(sqlCommand)) {
            String catalog = context$1.getCurrentCatalog();
            $this.callback$1(new java.lang.StringBuilder(2).append(command).append(": ").append(catalog).toString(), callbackFunc$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (SqlCommand$SHOW_DATABASES$.MODULE$.equals(sqlCommand)) {
            String[] databases = context$1.listDatabases();
            $this.callback$1(new java.lang.StringBuilder(2).append(command).append(": ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])databases)).mkString("\n")).toString(), callbackFunc$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (SqlCommand$SHOW_CURRENT_DATABASE$.MODULE$.equals(sqlCommand)) {
            String database = context$1.getCurrentDatabase();
            $this.callback$1(new java.lang.StringBuilder(2).append(command).append(": ").append(database).toString(), callbackFunc$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (SqlCommand$SHOW_TABLES$.MODULE$.equals(sqlCommand)) {
            String[] tables = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])context$1.listTables())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FlinkSqlExecutor$.$anonfun$executeSql$4(x$1)));
            $this.callback$1(new java.lang.StringBuilder(2).append(command).append(": ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tables)).mkString("\n")).toString(), callbackFunc$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (SqlCommand$SHOW_FUNCTIONS$.MODULE$.equals(sqlCommand)) {
            String[] functions = context$1.listUserDefinedFunctions();
            $this.callback$1(new java.lang.StringBuilder(2).append(command).append(": ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])functions)).mkString("\n")).toString(), callbackFunc$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (SqlCommand$SHOW_MODULES$.MODULE$.equals(sqlCommand)) {
            String[] modules = context$1.listModules();
            $this.callback$1(new java.lang.StringBuilder(2).append(command).append(": ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])modules)).mkString("\n")).toString(), callbackFunc$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            boolean bl = SqlCommand$DESC$.MODULE$.equals(sqlCommand) ? true : SqlCommand$DESCRIBE$.MODULE$.equals(sqlCommand);
            if (bl) {
                TableSchema schema = context$1.scan(new String[]{args}).getSchema();
                StringBuilder builder = new StringBuilder();
                builder.append("Column\tType\n");
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), schema.getFieldCount()).foreach((Function1 & Serializable & scala.Serializable)i -> builder.append(new java.lang.StringBuilder(2).append((String)schema.getFieldName(BoxesRunTime.unboxToInt((Object)i)).get()).append("\t").append(schema.getFieldDataType(BoxesRunTime.unboxToInt((Object)i)).get()).append("\n").toString()));
                $this.callback$1(builder.toString(), callbackFunc$1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (SqlCommand$EXPLAIN$.MODULE$.equals(sqlCommand)) {
                TableResult tableResult = context$1.executeSql(x.originSql());
                String r = ((Row)tableResult.collect().next()).getField(0).toString();
                $this.callback$1(r, callbackFunc$1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (SqlCommand$SET$.MODULE$.equals(sqlCommand)) {
                String operand = x.operands()[1];
                MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(7).append(command).append(": ").append(args).append(" --> ").append(operand).toString());
                context$1.getConfig().getConfiguration().setString(args, operand);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                boolean bl2 = SqlCommand$RESET$.MODULE$.equals(sqlCommand) ? true : SqlCommand$RESET_ALL$.MODULE$.equals(sqlCommand);
                if (bl2) {
                    HashMap confData;
                    Field confDataField = Configuration.class.getDeclaredField("confData");
                    confDataField.setAccessible(true);
                    HashMap hashMap = confData = (HashMap)confDataField.get(context$1.getConfig().getConfiguration());
                    synchronized (hashMap) {
                        Object object;
                        SqlCommand sqlCommand2 = x.command();
                        SqlCommand$RESET$ sqlCommand$RESET$ = SqlCommand$RESET$.MODULE$;
                        if (!(sqlCommand2 != null ? !sqlCommand2.equals(sqlCommand$RESET$) : sqlCommand$RESET$ != null)) {
                            object = confData.remove(args);
                        } else {
                            confData.clear();
                            object = BoxedUnit.UNIT;
                        }
                    }
                    MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(2).append(command).append(": ").append(args).toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    boolean bl3 = SqlCommand$BEGIN_STATEMENT_SET$.MODULE$.equals(sqlCommand) ? true : SqlCommand$END_STATEMENT_SET$.MODULE$.equals(sqlCommand);
                    if (bl3) {
                        MODULE$.logWarn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(20).append("SQL Client Syntax: ").append(x.command().name()).append(" ").toString());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (SqlCommand$INSERT$.MODULE$.equals(sqlCommand)) {
                        statementSet$1.addInsertSql(x.originSql());
                        hasInsert$1.elem = true;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        if (SqlCommand$SELECT$.MODULE$.equals(sqlCommand)) {
                            MODULE$.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "StreamPark dose not support 'SELECT' statement now!");
                            throw new RuntimeException("StreamPark dose not support 'select' statement now!");
                        }
                        boolean bl4 = SqlCommand$DELETE$.MODULE$.equals(sqlCommand) ? true : SqlCommand$UPDATE$.MODULE$.equals(sqlCommand);
                        if (bl4) {
                            String string = runMode$1;
                            String string2 = "STREAMING";
                            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                throw new UnsupportedOperationException(new java.lang.StringBuilder(133).append("Currently, ").append(command.toUpperCase()).append(" statement only supports in batch mode, ").append("and it requires the target table connector implements the SupportsRowLevelDelete, ").append(new java.lang.StringBuilder(112).append("For more details please refer to: https://nightlies.apache.org/flink/flink-docs-release-1.18/docs/dev/table/sql/").append(command).toString()).toString());
                            }
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            BoxedUnit boxedUnit;
                            try {
                                FlinkSqlExecutor$.MODULE$.lock.lock();
                                TableResult result = context$1.executeSql(x.originSql());
                                MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(1).append(command).append(":").append(args).toString());
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            finally {
                                if (FlinkSqlExecutor$.MODULE$.lock.isHeldByCurrentThread()) {
                                    FlinkSqlExecutor$.MODULE$.lock.unlock();
                                }
                            }
                            BoxedUnit boxedUnit2 = boxedUnit;
                        }
                    }
                }
            }
        }
    }

    private FlinkSqlExecutor$() {
        MODULE$ = this;
        Logger.$init$(this);
        this.lock = new ReentrantReadWriteLock().writeLock();
    }
}

