/*
 * Decompiled with CFR 0.152.
 */
package com.p6spy.engine.wrapper;

import com.p6spy.engine.common.PreparedStatementInformation;
import com.p6spy.engine.common.ResultSetInformation;
import com.p6spy.engine.event.JdbcEventListener;
import com.p6spy.engine.wrapper.ResultSetWrapper;
import com.p6spy.engine.wrapper.StatementWrapper;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class PreparedStatementWrapper
extends StatementWrapper
implements PreparedStatement {
    private final PreparedStatement delegate;
    private final PreparedStatementInformation statementInformation;

    public static PreparedStatement wrap(PreparedStatement delegate, PreparedStatementInformation preparedStatementInformation, JdbcEventListener eventListener) {
        if (delegate == null) {
            return null;
        }
        return new PreparedStatementWrapper(delegate, preparedStatementInformation, eventListener);
    }

    protected PreparedStatementWrapper(PreparedStatement delegate, PreparedStatementInformation preparedStatementInformation, JdbcEventListener eventListener) {
        super(delegate, preparedStatementInformation, eventListener);
        this.delegate = delegate;
        this.statementInformation = preparedStatementInformation;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        try {
            this.eventListener.onBeforeExecuteQuery(this.statementInformation);
            ResultSet resultSet = ResultSetWrapper.wrap(this.delegate.executeQuery(), new ResultSetInformation(this.statementInformation), this.eventListener);
            return resultSet;
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterExecuteQuery(this.statementInformation, System.nanoTime() - start, e);
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        int rowCount = 0;
        try {
            this.eventListener.onBeforeExecuteUpdate(this.statementInformation);
            int n = rowCount = this.delegate.executeUpdate();
            return n;
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterExecuteUpdate(this.statementInformation, System.nanoTime() - start, rowCount, e);
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        SQLException e = null;
        try {
            this.delegate.setNull(parameterIndex, sqlType);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, null, e);
        }
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        SQLException e = null;
        try {
            this.delegate.setBoolean(parameterIndex, x);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        SQLException e = null;
        try {
            this.delegate.setByte(parameterIndex, x);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        SQLException e = null;
        try {
            this.delegate.setShort(parameterIndex, x);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        SQLException e = null;
        try {
            this.delegate.setInt(parameterIndex, x);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        SQLException e = null;
        try {
            this.delegate.setLong(parameterIndex, x);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        SQLException e = null;
        try {
            this.delegate.setFloat(parameterIndex, x);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, Float.valueOf(x), e);
        }
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        SQLException e = null;
        try {
            this.delegate.setDouble(parameterIndex, x);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        SQLException e = null;
        try {
            this.delegate.setBigDecimal(parameterIndex, x);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        SQLException e = null;
        try {
            this.delegate.setString(parameterIndex, x);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        SQLException e = null;
        try {
            this.delegate.setBytes(parameterIndex, x);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        SQLException e = null;
        try {
            this.delegate.setDate(parameterIndex, x);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        SQLException e = null;
        try {
            this.delegate.setTime(parameterIndex, x);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        SQLException e = null;
        try {
            this.delegate.setTimestamp(parameterIndex, x);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        SQLException e = null;
        try {
            this.delegate.setAsciiStream(parameterIndex, x, length);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        SQLException e = null;
        try {
            this.delegate.setUnicodeStream(parameterIndex, x, length);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        SQLException e = null;
        try {
            this.delegate.setBinaryStream(parameterIndex, x, length);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void clearParameters() throws SQLException {
        this.delegate.clearParameters();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        SQLException e = null;
        try {
            this.delegate.setObject(parameterIndex, x, targetSqlType);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        SQLException e = null;
        try {
            this.delegate.setObject(parameterIndex, x);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public boolean execute() throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        try {
            this.eventListener.onBeforeExecute(this.statementInformation);
            boolean bl = this.delegate.execute();
            return bl;
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterExecute(this.statementInformation, System.nanoTime() - start, e);
        }
    }

    @Override
    public void addBatch() throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        try {
            this.eventListener.onBeforeAddBatch(this.statementInformation);
            this.delegate.addBatch();
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterAddBatch(this.statementInformation, System.nanoTime() - start, e);
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        SQLException e = null;
        try {
            this.delegate.setCharacterStream(parameterIndex, reader, length);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, reader, e);
        }
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        SQLException e = null;
        try {
            this.delegate.setRef(parameterIndex, x);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        SQLException e = null;
        try {
            this.delegate.setBlob(parameterIndex, x);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        SQLException e = null;
        try {
            this.delegate.setClob(parameterIndex, x);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        SQLException e = null;
        try {
            this.delegate.setArray(parameterIndex, x);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        SQLException e = null;
        try {
            this.delegate.setDate(parameterIndex, x, cal);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        SQLException e = null;
        try {
            this.delegate.setTime(parameterIndex, x, cal);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        SQLException e = null;
        try {
            this.delegate.setTimestamp(parameterIndex, x, cal);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        SQLException e = null;
        try {
            this.delegate.setNull(parameterIndex, sqlType, typeName);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, null, e);
        }
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        SQLException e = null;
        try {
            this.delegate.setURL(parameterIndex, x);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        SQLException e = null;
        try {
            this.delegate.setRowId(parameterIndex, x);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        SQLException e = null;
        try {
            this.delegate.setNString(parameterIndex, value);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, value, e);
        }
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        SQLException e = null;
        try {
            this.delegate.setNCharacterStream(parameterIndex, value, length);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, value, e);
        }
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        SQLException e = null;
        try {
            this.delegate.setNClob(parameterIndex, value);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, value, e);
        }
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        SQLException e = null;
        try {
            this.delegate.setClob(parameterIndex, reader, length);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, reader, e);
        }
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        SQLException e = null;
        try {
            this.delegate.setBlob(parameterIndex, inputStream, length);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, inputStream, e);
        }
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        SQLException e = null;
        try {
            this.delegate.setNClob(parameterIndex, reader, length);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, reader, e);
        }
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        SQLException e = null;
        try {
            this.delegate.setSQLXML(parameterIndex, xmlObject);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, xmlObject, e);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        SQLException e = null;
        try {
            this.delegate.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        SQLException e = null;
        try {
            this.delegate.setAsciiStream(parameterIndex, x, length);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        SQLException e = null;
        try {
            this.delegate.setBinaryStream(parameterIndex, x, length);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        SQLException e = null;
        try {
            this.delegate.setCharacterStream(parameterIndex, reader, length);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, reader, e);
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        SQLException e = null;
        try {
            this.delegate.setAsciiStream(parameterIndex, x);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        SQLException e = null;
        try {
            this.delegate.setBinaryStream(parameterIndex, x);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        SQLException e = null;
        try {
            this.delegate.setCharacterStream(parameterIndex, reader);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, reader, e);
        }
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        SQLException e = null;
        try {
            this.delegate.setNCharacterStream(parameterIndex, value);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, value, e);
        }
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        SQLException e = null;
        try {
            this.delegate.setClob(parameterIndex, reader);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, reader, e);
        }
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        SQLException e = null;
        try {
            this.delegate.setBlob(parameterIndex, inputStream);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, inputStream, e);
        }
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        SQLException e = null;
        try {
            this.delegate.setNClob(parameterIndex, reader);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, reader, e);
        }
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.delegate.getParameterMetaData();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.delegate.getMetaData();
    }
}

