/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.util.FileUtils;

public class DirectoryStateHandle
implements StateObject {
    private static final long serialVersionUID = 1L;
    private final String directoryString;
    private transient Path directory;

    public DirectoryStateHandle(@Nonnull Path directory) {
        this.directory = directory;
        this.directoryString = directory.toString();
    }

    @Override
    public void discardState() throws IOException {
        this.ensurePath();
        FileUtils.deleteDirectory((File)this.directory.toFile());
    }

    @Override
    public long getStateSize() {
        return 0L;
    }

    @Nonnull
    public Path getDirectory() {
        this.ensurePath();
        return this.directory;
    }

    private void ensurePath() {
        if (this.directory == null) {
            this.directory = Paths.get(this.directoryString, new String[0]);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DirectoryStateHandle that = (DirectoryStateHandle)o;
        return this.directoryString.equals(that.directoryString);
    }

    public int hashCode() {
        return this.directoryString.hashCode();
    }

    public String toString() {
        return "DirectoryStateHandle{directory=" + this.directoryString + '}';
    }
}

