/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.entity;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.streampark.common.conf.Workspace;
import org.apache.streampark.console.base.util.MavenUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TableName(value="t_flink_project")
public class Project
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(Project.class);
    @TableId(type=IdType.AUTO)
    private Long id;
    private Long teamId;
    private String name;
    private String url;
    private String refs;
    private Date lastBuild;
    @TableField(updateStrategy=FieldStrategy.IGNORED)
    private String userName;
    @TableField(updateStrategy=FieldStrategy.IGNORED)
    private String password;
    @TableField(updateStrategy=FieldStrategy.IGNORED)
    private String prvkeyPath;
    private Integer repository;
    private String pom;
    private String buildArgs;
    private String description;
    private Integer buildState;
    private Integer type;
    private Date createTime;
    private Date modifyTime;
    private transient String module;
    private transient String dateFrom;
    private transient String dateTo;

    @JsonIgnore
    public File getAppSource() {
        File sourcePath = new File(Workspace.PROJECT_LOCAL_PATH());
        if (!sourcePath.exists() && !sourcePath.mkdirs()) {
            throw new IllegalStateException("Failed to create project source path: " + sourcePath.getAbsolutePath());
        }
        if (sourcePath.isFile()) {
            throw new IllegalArgumentException("[StreamPark] project source base path: " + sourcePath.getAbsolutePath() + " must be directory");
        }
        String sourceDir = this.getSourceDirName();
        String newPath = String.format("%s/%s", sourcePath.getAbsolutePath(), this.id);
        File file = new File(newPath, sourceDir);
        if (!file.exists() && !file.mkdirs()) {
            throw new IllegalStateException("Failed to create directory: " + file.getAbsolutePath());
        }
        return file;
    }

    private String getSourceDirName() {
        String branches = "main";
        if (StringUtils.isNotBlank((CharSequence)this.refs)) {
            branches = this.refs.startsWith("refs/heads/") ? this.refs.replace("refs/heads/", "") : (this.refs.startsWith("refs/tags/") ? this.refs.replace("refs/tags/", "") : this.refs);
        }
        String rootName = this.url.replaceAll(".*/|\\.git|\\.svn", "");
        return rootName.concat("-").concat(branches);
    }

    @JsonIgnore
    public File getDistHome() {
        return new File(Workspace.APP_LOCAL_DIST(), this.id.toString());
    }

    @JsonIgnore
    public File getGitRepository() {
        File home = this.getAppSource();
        return new File(home, ".git");
    }

    public void delete() throws IOException {
        FileUtils.deleteDirectory((File)this.getAppSource());
        FileUtils.deleteDirectory((File)this.getDistHome());
    }

    @JsonIgnore
    public boolean isCloned() {
        File repository = this.getGitRepository();
        return repository.exists();
    }

    public void cleanCloned() throws IOException {
        if (this.isCloned()) {
            this.delete();
        }
    }

    @JsonIgnore
    public String getMavenWorkHome() {
        String buildHome = this.getAppSource().getAbsolutePath();
        if (StringUtils.isBlank((CharSequence)this.getPom())) {
            return buildHome;
        }
        return new File(buildHome.concat("/").concat(this.getPom())).getParentFile().getAbsolutePath();
    }

    @JsonIgnore
    public String getLog4BuildStart() {
        return String.format("%sproject : %s\nrefs: %s\ncommand : %s\n\n", this.getLogHeader("maven install"), this.getName(), this.getRefs(), this.getMavenBuildArgs());
    }

    @JsonIgnore
    public String getLog4CloneStart() {
        return String.format("%sproject  : %s\nrefs : %s\nworkspace: %s\n\n", this.getLogHeader("git clone"), this.getName(), this.getRefs(), this.getAppSource());
    }

    @JsonIgnore
    private String getLogHeader(String header) {
        return "---------------------------------[ " + header + " ]---------------------------------\n";
    }

    @JsonIgnore
    public String getMavenBuildArgs() {
        return MavenUtils.getMavenArgs(this.buildArgs);
    }

    public Long getId() {
        return this.id;
    }

    public Long getTeamId() {
        return this.teamId;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getRefs() {
        return this.refs;
    }

    public Date getLastBuild() {
        return this.lastBuild;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPrvkeyPath() {
        return this.prvkeyPath;
    }

    public Integer getRepository() {
        return this.repository;
    }

    public String getPom() {
        return this.pom;
    }

    public String getBuildArgs() {
        return this.buildArgs;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getBuildState() {
        return this.buildState;
    }

    public Integer getType() {
        return this.type;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getModifyTime() {
        return this.modifyTime;
    }

    public String getModule() {
        return this.module;
    }

    public String getDateFrom() {
        return this.dateFrom;
    }

    public String getDateTo() {
        return this.dateTo;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setTeamId(Long teamId) {
        this.teamId = teamId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setRefs(String refs) {
        this.refs = refs;
    }

    public void setLastBuild(Date lastBuild) {
        this.lastBuild = lastBuild;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPrvkeyPath(String prvkeyPath) {
        this.prvkeyPath = prvkeyPath;
    }

    public void setRepository(Integer repository) {
        this.repository = repository;
    }

    public void setPom(String pom) {
        this.pom = pom;
    }

    public void setBuildArgs(String buildArgs) {
        this.buildArgs = buildArgs;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setBuildState(Integer buildState) {
        this.buildState = buildState;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public void setDateFrom(String dateFrom) {
        this.dateFrom = dateFrom;
    }

    public void setDateTo(String dateTo) {
        this.dateTo = dateTo;
    }
}

