/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.translators;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.sink.Sink;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.api.graph.TransformationTranslator;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.transformations.SinkTransformation;
import org.apache.flink.streaming.runtime.operators.sink.CommitterOperatorFactory;
import org.apache.flink.streaming.runtime.operators.sink.SinkOperatorFactory;
import org.apache.flink.streaming.util.graph.StreamGraphUtils;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class SinkTransformationTranslator<InputT, CommT, WriterStateT, GlobalCommT>
implements TransformationTranslator<Object, SinkTransformation<InputT, CommT, WriterStateT, GlobalCommT>> {
    protected static final Logger LOG = LoggerFactory.getLogger(SinkTransformationTranslator.class);

    @Override
    public Collection<Integer> translateForBatch(SinkTransformation<InputT, CommT, WriterStateT, GlobalCommT> transformation, TransformationTranslator.Context context) {
        StreamGraphUtils.validateTransformationUid(context.getStreamGraph(), transformation);
        int parallelism = this.getParallelism(transformation, context);
        try {
            this.internalTranslate(transformation, parallelism, true, context);
        }
        catch (IOException e) {
            throw new FlinkRuntimeException("Could not add the Committer or GlobalCommitter to the stream graph.", (Throwable)e);
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<Integer> translateForStreaming(SinkTransformation<InputT, CommT, WriterStateT, GlobalCommT> transformation, TransformationTranslator.Context context) {
        StreamGraphUtils.validateTransformationUid(context.getStreamGraph(), transformation);
        int parallelism = this.getParallelism(transformation, context);
        try {
            this.internalTranslate(transformation, parallelism, false, context);
        }
        catch (IOException e) {
            throw new FlinkRuntimeException("Could not add the Committer or GlobalCommitter to the stream graph.", (Throwable)e);
        }
        return Collections.emptyList();
    }

    private void internalTranslate(SinkTransformation<InputT, CommT, WriterStateT, GlobalCommT> sinkTransformation, int writerParallelism, boolean batch, TransformationTranslator.Context context) throws IOException {
        StreamGraphUtils.validateTransformationUid(context.getStreamGraph(), sinkTransformation);
        Sink<InputT, CommT, WriterStateT, GlobalCommT> sink = sinkTransformation.getSink();
        boolean needsCommitterOperator = batch && sink.getCommittableSerializer().isPresent() || sink.getGlobalCommittableSerializer().isPresent();
        int writerId = this.addWriterAndCommitter(sinkTransformation, writerParallelism, batch, needsCommitterOperator, context);
        if (needsCommitterOperator) {
            this.addGlobalCommitter(writerId, sinkTransformation, batch, context);
        }
    }

    private int addWriterAndCommitter(SinkTransformation<InputT, CommT, WriterStateT, GlobalCommT> sinkTransformation, int parallelism, boolean batch, boolean shouldEmit, TransformationTranslator.Context context) {
        Sink<InputT, CommT, WriterStateT, GlobalCommT> sink = sinkTransformation.getSink();
        Preconditions.checkState((sinkTransformation.getInputs().size() == 1 ? 1 : 0) != 0);
        Transformation<?> input = sinkTransformation.getInputs().get(0);
        TypeInformation inputTypeInfo = input.getOutputType();
        SinkOperatorFactory<InputT, CommT, WriterStateT> factory = new SinkOperatorFactory<InputT, CommT, WriterStateT>(sink, batch, shouldEmit);
        ChainingStrategy chainingStrategy = sinkTransformation.getChainingStrategy();
        if (chainingStrategy != null) {
            factory.setChainingStrategy(chainingStrategy);
        }
        String format = batch && shouldEmit ? "Sink %s Writer" : "Sink %s";
        return this.addOperatorToStreamGraph(factory, context.getStreamNodeIds(input), inputTypeInfo, TypeInformation.of(byte[].class), String.format(format, sinkTransformation.getName()), sinkTransformation.getUid(), parallelism, sinkTransformation.getMaxParallelism(), sinkTransformation, context);
    }

    private void addGlobalCommitter(int inputId, SinkTransformation<InputT, CommT, WriterStateT, GlobalCommT> sinkTransformation, boolean batch, TransformationTranslator.Context context) {
        Sink<InputT, CommT, WriterStateT, GlobalCommT> sink = sinkTransformation.getSink();
        String format = batch ? "Sink %s Committer" : "Sink %s Global Committer";
        this.addOperatorToStreamGraph(new CommitterOperatorFactory<CommT, GlobalCommT>(sink, batch), Collections.singletonList(inputId), TypeInformation.of(byte[].class), null, String.format(format, sinkTransformation.getName()), sinkTransformation.getUid() == null ? null : String.format(format, sinkTransformation.getUid()), 1, 1, sinkTransformation, context);
    }

    private int getParallelism(SinkTransformation<InputT, CommT, WriterStateT, GlobalCommT> sinkTransformation, TransformationTranslator.Context context) {
        return sinkTransformation.getParallelism() != -1 ? sinkTransformation.getParallelism() : context.getStreamGraph().getExecutionConfig().getParallelism();
    }

    private <IN, OUT> int addOperatorToStreamGraph(StreamOperatorFactory<OUT> operatorFactory, Collection<Integer> inputs, TypeInformation<IN> inTypeInfo, TypeInformation<OUT> outTypInfo, String name, @Nullable String uid, int parallelism, int maxParallelism, SinkTransformation<InputT, CommT, WriterStateT, GlobalCommT> sinkTransformation, TransformationTranslator.Context context) {
        StreamGraph streamGraph = context.getStreamGraph();
        String slotSharingGroup = context.getSlotSharingGroup();
        int transformationId = Transformation.getNewNodeId();
        streamGraph.addOperator(transformationId, slotSharingGroup, sinkTransformation.getCoLocationGroupKey(), operatorFactory, inTypeInfo, outTypInfo, name);
        streamGraph.setParallelism(transformationId, parallelism);
        streamGraph.setMaxParallelism(transformationId, maxParallelism);
        StreamGraphUtils.configureBufferTimeout(streamGraph, transformationId, sinkTransformation, context.getDefaultBufferTimeout());
        if (uid != null) {
            streamGraph.setTransformationUID(transformationId, uid);
        }
        for (int input : inputs) {
            streamGraph.addEdge(input, transformationId, 0);
        }
        return transformationId;
    }
}

