/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job.checkpoints;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.checkpoint.AbstractCheckpointStats;
import org.apache.flink.runtime.checkpoint.CheckpointStatsCounts;
import org.apache.flink.runtime.checkpoint.CheckpointStatsHistory;
import org.apache.flink.runtime.checkpoint.CheckpointStatsSnapshot;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStatsSummarySnapshot;
import org.apache.flink.runtime.checkpoint.RestoredCheckpointStats;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.job.AbstractAccessExecutionGraphHandler;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.ErrorResponseBody;
import org.apache.flink.runtime.rest.messages.JobMessageParameters;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.rest.messages.checkpoints.CheckpointStatistics;
import org.apache.flink.runtime.rest.messages.checkpoints.CheckpointingStatistics;
import org.apache.flink.runtime.rest.messages.checkpoints.StatsSummaryDto;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.flink.runtime.webmonitor.history.OnlyExecutionGraphJsonArchivist;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;

public class CheckpointingStatisticsHandler
extends AbstractAccessExecutionGraphHandler<CheckpointingStatistics, JobMessageParameters>
implements OnlyExecutionGraphJsonArchivist {
    public CheckpointingStatisticsHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, CheckpointingStatistics, JobMessageParameters> messageHeaders, ExecutionGraphCache executionGraphCache, Executor executor) {
        super(leaderRetriever, timeout, responseHeaders, messageHeaders, executionGraphCache, executor);
    }

    @Override
    protected CheckpointingStatistics handleRequest(HandlerRequest<EmptyRequestBody, JobMessageParameters> request, AccessExecutionGraph executionGraph) throws RestHandlerException {
        return CheckpointingStatisticsHandler.createCheckpointingStatistics(executionGraph);
    }

    @Override
    public Collection<ArchivedJson> archiveJsonWithPath(AccessExecutionGraph graph) throws IOException {
        ResponseBody json;
        try {
            json = CheckpointingStatisticsHandler.createCheckpointingStatistics(graph);
        }
        catch (RestHandlerException rhe) {
            json = new ErrorResponseBody(rhe.getMessage());
        }
        String path = this.getMessageHeaders().getTargetRestEndpointURL().replace(":jobid", graph.getJobID().toString());
        return Collections.singletonList(new ArchivedJson(path, json));
    }

    private static CheckpointingStatistics createCheckpointingStatistics(AccessExecutionGraph executionGraph) throws RestHandlerException {
        CheckpointStatsSnapshot checkpointStatsSnapshot = executionGraph.getCheckpointStatsSnapshot();
        if (checkpointStatsSnapshot == null) {
            throw new RestHandlerException("Checkpointing has not been enabled.", HttpResponseStatus.NOT_FOUND, RestHandlerException.LoggingBehavior.IGNORE);
        }
        CheckpointStatsCounts checkpointStatsCounts = checkpointStatsSnapshot.getCounts();
        CheckpointingStatistics.Counts counts = new CheckpointingStatistics.Counts(checkpointStatsCounts.getNumberOfRestoredCheckpoints(), checkpointStatsCounts.getTotalNumberOfCheckpoints(), checkpointStatsCounts.getNumberOfInProgressCheckpoints(), checkpointStatsCounts.getNumberOfCompletedCheckpoints(), checkpointStatsCounts.getNumberOfFailedCheckpoints());
        CompletedCheckpointStatsSummarySnapshot checkpointStatsSummary = checkpointStatsSnapshot.getSummaryStats();
        CheckpointingStatistics.Summary summary = new CheckpointingStatistics.Summary(StatsSummaryDto.valueOf(checkpointStatsSummary.getStateSizeStats()), StatsSummaryDto.valueOf(checkpointStatsSummary.getEndToEndDurationStats()), new StatsSummaryDto(0L, 0L, 0L, 0.0, 0.0, 0.0, 0.0, 0.0), StatsSummaryDto.valueOf(checkpointStatsSummary.getProcessedDataStats()), StatsSummaryDto.valueOf(checkpointStatsSummary.getPersistedDataStats()));
        CheckpointStatsHistory checkpointStatsHistory = checkpointStatsSnapshot.getHistory();
        CheckpointStatistics.CompletedCheckpointStatistics completed = checkpointStatsHistory.getLatestCompletedCheckpoint() != null ? (CheckpointStatistics.CompletedCheckpointStatistics)CheckpointStatistics.generateCheckpointStatistics(checkpointStatsHistory.getLatestCompletedCheckpoint(), false) : null;
        CheckpointStatistics.CompletedCheckpointStatistics savepoint = checkpointStatsHistory.getLatestSavepoint() != null ? (CheckpointStatistics.CompletedCheckpointStatistics)CheckpointStatistics.generateCheckpointStatistics(checkpointStatsHistory.getLatestSavepoint(), false) : null;
        CheckpointStatistics.FailedCheckpointStatistics failed = checkpointStatsHistory.getLatestFailedCheckpoint() != null ? (CheckpointStatistics.FailedCheckpointStatistics)CheckpointStatistics.generateCheckpointStatistics(checkpointStatsHistory.getLatestFailedCheckpoint(), false) : null;
        RestoredCheckpointStats restoredCheckpointStats = checkpointStatsSnapshot.getLatestRestoredCheckpoint();
        CheckpointingStatistics.RestoredCheckpointStatistics restored = restoredCheckpointStats == null ? null : new CheckpointingStatistics.RestoredCheckpointStatistics(restoredCheckpointStats.getCheckpointId(), restoredCheckpointStats.getRestoreTimestamp(), restoredCheckpointStats.getProperties().isSavepoint(), restoredCheckpointStats.getExternalPath());
        CheckpointingStatistics.LatestCheckpoints latestCheckpoints = new CheckpointingStatistics.LatestCheckpoints(completed, savepoint, failed, restored);
        ArrayList<CheckpointStatistics> history = new ArrayList<CheckpointStatistics>(16);
        for (AbstractCheckpointStats abstractCheckpointStats : checkpointStatsSnapshot.getHistory().getCheckpoints()) {
            history.add(CheckpointStatistics.generateCheckpointStatistics(abstractCheckpointStats, false));
        }
        return new CheckpointingStatistics(counts, summary, latestCheckpoints, history);
    }
}

