/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.system.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.streampark.common.util.CURLBuilder;
import org.apache.streampark.console.base.domain.RestRequest;
import org.apache.streampark.console.base.domain.RestResponse;
import org.apache.streampark.console.base.exception.InternalException;
import org.apache.streampark.console.core.enums.AccessTokenState;
import org.apache.streampark.console.core.service.ServiceHelper;
import org.apache.streampark.console.system.entity.AccessToken;
import org.apache.streampark.console.system.service.AccessTokenService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="ACCESS_TOKEN_TAG")
@RestController
@RequestMapping(value={"token"})
public class AccessTokenController {
    @Autowired
    private AccessTokenService accessTokenService;
    @Autowired
    private ServiceHelper serviceHelper;

    @Operation(summary="Create token")
    @Parameters(value={@Parameter(name="userId", description="user id", required=true, example="100000", schema=@Schema(implementation=Long.class)), @Parameter(name="expireTime", description="token expire time, yyyy-MM-dd HH:mm:ss", required=true, example="9999-01-01 00:00:00", schema=@Schema(implementation=String.class)), @Parameter(name="description", description="token description", schema=@Schema(implementation=String.class))})
    @PostMapping(value={"create"})
    @RequiresPermissions(value={"token:add"})
    public RestResponse createToken(@NotBlank(message="{required}") @NotBlank(message="{required}") Long userId, String expireTime, @RequestParam(required=false) String description) throws InternalException {
        return this.accessTokenService.create(userId, expireTime, description);
    }

    @Operation(summary="Verify current user token")
    @PostMapping(value={"check"})
    public RestResponse verifyToken() {
        Long userId = this.serviceHelper.getUserId();
        RestResponse restResponse = RestResponse.success();
        if (userId != null) {
            AccessToken accessToken = this.accessTokenService.getByUserId(userId);
            if (accessToken == null) {
                restResponse.data(AccessTokenState.NULL.get());
            } else if (AccessToken.STATUS_DISABLE.equals(accessToken.getFinalStatus())) {
                restResponse.data(AccessTokenState.INVALID.get());
            } else {
                restResponse.data(AccessTokenState.OK.get());
            }
        } else {
            restResponse.data(AccessTokenState.INVALID.get());
        }
        return restResponse;
    }

    @Operation(summary="List tokens")
    @Parameters(value={@Parameter(name="userId", in=ParameterIn.QUERY, description="user id", schema=@Schema(implementation=Long.class))})
    @PostMapping(value={"list"})
    @RequiresPermissions(value={"token:view"})
    public RestResponse tokensList(RestRequest restRequest, @Parameter(hidden=true) AccessToken accessToken) {
        IPage<AccessToken> accessTokens = this.accessTokenService.page(accessToken, restRequest);
        return RestResponse.success(accessTokens);
    }

    @Operation(summary="Toggle token")
    @Parameters(value={@Parameter(name="tokenId", description="token id", required=true, example="1", schema=@Schema(implementation=Long.class))})
    @PostMapping(value={"toggle"})
    @RequiresPermissions(value={"token:add"})
    public RestResponse toggleToken(@NotNull(message="{required}") @NotNull(message="{required}") Long tokenId) {
        return this.accessTokenService.toggleToken(tokenId);
    }

    @Operation(summary="Delete token")
    @Parameters(value={@Parameter(name="tokenId", description="token id", required=true, example="1", schema=@Schema(implementation=Long.class))})
    @DeleteMapping(value={"delete"})
    @RequiresPermissions(value={"token:delete"})
    public RestResponse deleteToken(@NotBlank(message="{required}") @NotBlank(message="{required}") Long tokenId) {
        boolean res = this.accessTokenService.deleteToken(tokenId);
        return RestResponse.success(res);
    }

    @Operation(summary="Generate api with token")
    @PostMapping(value={"curl"})
    public RestResponse copyRestApiCurl(@NotBlank(message="{required}") @NotBlank(message="{required}") String appId, @NotBlank(message="{required}") @NotBlank(message="{required}") String baseUrl, @NotBlank(message="{required}") @NotBlank(message="{required}") String path) {
        String resultCURL = null;
        CURLBuilder curlBuilder = new CURLBuilder(baseUrl + path);
        curlBuilder.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8").addHeader("Authorization", this.accessTokenService.getByUserId(this.serviceHelper.getUserId()).getToken());
        if ("/flink/app/start".equalsIgnoreCase(path)) {
            resultCURL = curlBuilder.addFormData("allowNonRestored", "false").addFormData("savePoint", "").addFormData("savePointed", "false").addFormData("id", appId).build();
        } else if ("/flink/app/cancel".equalsIgnoreCase(path)) {
            resultCURL = curlBuilder.addFormData("id", appId).addFormData("savePointed", "false").addFormData("drain", "false").addFormData("savePoint", "").build();
        }
        return RestResponse.success(resultCURL);
    }
}

