/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public final class HttpAuthUtils {
    public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    public static final String AUTHORIZATION = "Authorization";
    public static final String BASIC = "Basic";
    public static final String NEGOTIATE = "Negotiate";

    public static String getKerberosServiceTicket(String principal, String host, String serverHttpUrl, boolean assumeSubject) throws Exception {
        String serverPrincipal = ShimLoader.getHadoopThriftAuthBridge().getServerPrincipal(principal, host);
        if (assumeSubject) {
            AccessControlContext context = AccessController.getContext();
            Subject subject = Subject.getSubject(context);
            if (subject == null) {
                throw new Exception("The Subject is not set");
            }
            return Subject.doAs(subject, new HttpKerberosClientAction(serverPrincipal, serverHttpUrl));
        }
        UserGroupInformation clientUGI = ShimLoader.getHadoopThriftAuthBridge().getCurrentUGIWithConf("kerberos");
        return (String)clientUGI.doAs((PrivilegedExceptionAction)new HttpKerberosClientAction(serverPrincipal, serverHttpUrl));
    }

    private HttpAuthUtils() {
        throw new UnsupportedOperationException("Can't initialize class");
    }

    public static class HttpKerberosClientAction
    implements PrivilegedExceptionAction<String> {
        public static final String HTTP_RESPONSE = "HTTP_RESPONSE";
        public static final String SERVER_HTTP_URL = "SERVER_HTTP_URL";
        private final String serverPrincipal;
        private final String serverHttpUrl;
        private final Base64 base64codec;
        private final HttpContext httpContext;

        public HttpKerberosClientAction(String serverPrincipal, String serverHttpUrl) {
            this.serverPrincipal = serverPrincipal;
            this.serverHttpUrl = serverHttpUrl;
            this.base64codec = new Base64(0);
            this.httpContext = new BasicHttpContext();
            this.httpContext.setAttribute(SERVER_HTTP_URL, (Object)serverHttpUrl);
        }

        @Override
        public String run() throws Exception {
            Oid mechOid = new Oid("1.2.840.113554.1.2.2");
            Oid krb5PrincipalOid = new Oid("1.2.840.113554.1.2.2.1");
            GSSManager manager = GSSManager.getInstance();
            GSSName serverName = manager.createName(this.serverPrincipal, krb5PrincipalOid);
            GSSContext gssContext = manager.createContext(serverName, mechOid, null, 0);
            gssContext.requestMutualAuth(false);
            byte[] inToken = new byte[]{};
            byte[] outToken = gssContext.initSecContext(inToken, 0, inToken.length);
            gssContext.dispose();
            return new String(this.base64codec.encode(outToken));
        }
    }
}

