/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.space;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Provider;
import org.eclipse.sisu.Mediator;
import org.eclipse.sisu.inject.BeanLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MediationListener
implements TypeListener,
InjectionListener<Object> {
    private final List<Mediation<?, ?, ?>> mediation = new ArrayList();
    private final Provider<BeanLocator> locator;

    public MediationListener(Binder binder) {
        this.locator = binder.getProvider(BeanLocator.class);
    }

    public void mediate(Key key, Mediator mediator, Class watcherType) {
        this.mediation.add(new Mediation(key, mediator, watcherType));
    }

    public <T> void hear(TypeLiteral<T> type, TypeEncounter<T> encounter) {
        for (Mediation<?, ?, ?> m : this.mediation) {
            if (!m.watcherType.isAssignableFrom(type.getRawType())) continue;
            encounter.register(this);
        }
    }

    @Override
    public void afterInjection(Object watcher) {
        for (Mediation<?, ?, ?> m : this.mediation) {
            if (!m.watcherType.isInstance(watcher)) continue;
            this.locator.get().watch(m.watchedKey, m.mediator, watcher);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Mediation<Q extends Annotation, T, W> {
        final Key<T> watchedKey;
        final Mediator<Q, T, W> mediator;
        final Class<W> watcherType;

        Mediation(Key<T> watchedKey, Mediator<Q, T, W> mediator, Class<W> watcherType) {
            this.watchedKey = watchedKey;
            this.mediator = mediator;
            this.watcherType = watcherType;
        }
    }
}

