/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.transaction.jta;

import javax.transaction.TransactionManager;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.NucleusContext;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.transaction.jta.TransactionManagerLocator;

public class TransactionManagerFinder {
    NucleusContext nucleusContext;

    public TransactionManagerFinder(NucleusContext ctx) {
        this.nucleusContext = ctx;
    }

    public TransactionManager getTransactionManager(ClassLoaderResolver clr) {
        String jtaLocatorName = this.nucleusContext.getPersistenceConfiguration().getStringProperty("datanucleus.jtaLocator");
        PluginManager pluginMgr = this.nucleusContext.getPluginManager();
        if (jtaLocatorName != null) {
            try {
                TransactionManagerLocator locator = (TransactionManagerLocator)pluginMgr.createExecutableExtension("org.datanucleus.jta_locator", "name", jtaLocatorName, "class-name", new Class[]{ClassConstants.NUCLEUS_CONTEXT}, new Object[]{this.nucleusContext});
                return locator.getTransactionManager(clr);
            }
            catch (Exception e) {}
        } else {
            String[] locatorNames = pluginMgr.getAttributeValuesForExtension("org.datanucleus.jta_locator", null, null, "name");
            if (locatorNames != null) {
                for (int i = 0; i < locatorNames.length; ++i) {
                    try {
                        TransactionManager tm;
                        TransactionManagerLocator locator = (TransactionManagerLocator)pluginMgr.createExecutableExtension("org.datanucleus.jta_locator", "name", locatorNames[i], "class-name", new Class[]{ClassConstants.NUCLEUS_CONTEXT}, new Object[]{this.nucleusContext});
                        if (locator != null && (tm = locator.getTransactionManager(clr)) != null) {
                            return tm;
                        }
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
        return null;
    }
}

