/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.shaded.connection;

import java.util.concurrent.Callable;
import org.apache.curator.shaded.CuratorZookeeperClient;
import org.apache.curator.shaded.RetryLoop;
import org.apache.curator.shaded.connection.ConnectionHandlingPolicy;
import org.apache.curator.shaded.shaded.com.google.common.base.Preconditions;
import org.apache.curator.shaded.utils.ThreadUtils;

public class StandardConnectionHandlingPolicy
implements ConnectionHandlingPolicy {
    private final int expirationPercent;

    public StandardConnectionHandlingPolicy() {
        this(100);
    }

    public StandardConnectionHandlingPolicy(int expirationPercent) {
        Preconditions.checkArgument(expirationPercent > 0 && expirationPercent <= 100, "expirationPercent must be > 0 and <= 100");
        this.expirationPercent = expirationPercent;
    }

    @Override
    public int getSimulatedSessionExpirationPercent() {
        return this.expirationPercent;
    }

    @Override
    public <T> T callWithRetry(CuratorZookeeperClient client, Callable<T> proc) throws Exception {
        client.internalBlockUntilConnectedOrTimedOut();
        T result2 = null;
        RetryLoop retryLoop = client.newRetryLoop();
        while (retryLoop.shouldContinue()) {
            try {
                result2 = proc.call();
                retryLoop.markComplete();
            }
            catch (Exception e) {
                ThreadUtils.checkInterrupted(e);
                retryLoop.takeException(e);
            }
        }
        return result2;
    }

    @Override
    public ConnectionHandlingPolicy.CheckTimeoutsResult checkTimeouts(Callable<String> hasNewConnectionString, long connectionStartMs, int sessionTimeoutMs, int connectionTimeoutMs) throws Exception {
        if (hasNewConnectionString.call() != null) {
            return ConnectionHandlingPolicy.CheckTimeoutsResult.NEW_CONNECTION_STRING;
        }
        return ConnectionHandlingPolicy.CheckTimeoutsResult.NOP;
    }
}

