/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.identifier;

import org.datanucleus.store.rdbms.adapter.DatastoreAdapter;
import org.datanucleus.store.rdbms.identifier.DatastoreIdentifier;
import org.datanucleus.store.rdbms.identifier.IdentifierCase;
import org.datanucleus.store.rdbms.identifier.IdentifierFactory;

public class DatastoreIdentifierImpl
implements DatastoreIdentifier {
    protected final DatastoreAdapter dba;
    protected final IdentifierFactory factory;
    protected String identifierName;
    protected String catalogName;
    protected String schemaName;
    private String toString;

    protected DatastoreIdentifierImpl(IdentifierFactory factory, String sqlIdentifier) {
        this.dba = factory.getDatastoreAdapter();
        this.factory = factory;
        this.identifierName = this.toCase(sqlIdentifier);
    }

    protected String toCase(String identifierName) {
        if (this.factory.getIdentifierCase() == IdentifierCase.LOWER_CASE || this.factory.getIdentifierCase() == IdentifierCase.LOWER_CASE_QUOTED) {
            return identifierName.toLowerCase();
        }
        if (this.factory.getIdentifierCase() == IdentifierCase.UPPER_CASE || this.factory.getIdentifierCase() == IdentifierCase.UPPER_CASE_QUOTED) {
            return identifierName.toUpperCase();
        }
        return identifierName;
    }

    @Override
    public String getIdentifierName() {
        return this.identifierName;
    }

    @Override
    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    @Override
    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Override
    public String getCatalogName() {
        return this.catalogName;
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    public int hashCode() {
        return this.identifierName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DatastoreIdentifierImpl)) {
            return false;
        }
        DatastoreIdentifierImpl id = (DatastoreIdentifierImpl)obj;
        return !(!this.identifierName.equals(id.identifierName) || this.schemaName != null && id.schemaName != null && !this.schemaName.equals(id.schemaName) || this.catalogName != null && id.catalogName != null && !this.catalogName.equals(id.catalogName));
    }

    @Override
    public String toString() {
        if (this.toString == null) {
            String identifierQuoteString = this.dba.getIdentifierQuoteString();
            this.toString = this.dba.isReservedKeyword(this.identifierName) ? identifierQuoteString + this.identifierName + identifierQuoteString : (this.factory.getIdentifierCase() == IdentifierCase.LOWER_CASE_QUOTED || this.factory.getIdentifierCase() == IdentifierCase.MIXED_CASE_QUOTED || this.factory.getIdentifierCase() == IdentifierCase.UPPER_CASE_QUOTED ? identifierQuoteString + this.identifierName + identifierQuoteString : this.identifierName);
        }
        return this.toString;
    }

    @Override
    public final String getFullyQualifiedName(boolean adapterCase) {
        boolean supportsCatalogName = this.dba.supportsOption("CatalogInTableDefinition");
        boolean supportsSchemaName = this.dba.supportsOption("SchemaInTableDefinition");
        String separator = this.dba.getCatalogSeparator();
        StringBuffer name = new StringBuffer();
        if (supportsCatalogName && this.catalogName != null) {
            if (adapterCase) {
                name.append(this.factory.getIdentifierInAdapterCase(this.catalogName));
            } else {
                name.append(this.catalogName);
            }
            name.append(separator);
        }
        if (supportsSchemaName && this.schemaName != null) {
            if (adapterCase) {
                name.append(this.factory.getIdentifierInAdapterCase(this.schemaName));
            } else {
                name.append(this.schemaName);
            }
            name.append(separator);
        }
        if (adapterCase) {
            name.append(this.factory.getIdentifierInAdapterCase(this.toString()));
        } else {
            name.append(this.toString());
        }
        return name.toString();
    }
}

