/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.datasource.dbcp;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.store.rdbms.datasource.dbcp.AbandonedConfig;
import org.datanucleus.store.rdbms.datasource.dbcp.AbandonedTrace;
import org.datanucleus.store.rdbms.datasource.dbcp.pool.PoolableObjectFactory;
import org.datanucleus.store.rdbms.datasource.dbcp.pool.impl.GenericObjectPool;

public class AbandonedObjectPool
extends GenericObjectPool {
    private final AbandonedConfig config;
    private final List trace = new ArrayList();

    public AbandonedObjectPool(PoolableObjectFactory factory, AbandonedConfig config) {
        super(factory);
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object borrowObject() throws Exception {
        Object obj;
        if (this.config != null && this.config.getRemoveAbandoned() && this.getNumIdle() < 2 && this.getNumActive() > this.getMaxActive() - 3) {
            this.removeAbandoned();
        }
        if ((obj = super.borrowObject()) instanceof AbandonedTrace) {
            ((AbandonedTrace)obj).setStackTrace();
        }
        if (obj != null && this.config != null && this.config.getRemoveAbandoned()) {
            List list = this.trace;
            synchronized (list) {
                this.trace.add(obj);
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnObject(Object obj) throws Exception {
        if (this.config != null && this.config.getRemoveAbandoned()) {
            List list = this.trace;
            synchronized (list) {
                boolean foundObject = this.trace.remove(obj);
                if (!foundObject) {
                    return;
                }
            }
        }
        super.returnObject(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateObject(Object obj) throws Exception {
        if (this.config != null && this.config.getRemoveAbandoned()) {
            List list = this.trace;
            synchronized (list) {
                boolean foundObject = this.trace.remove(obj);
                if (!foundObject) {
                    return;
                }
            }
        }
        super.invalidateObject(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAbandoned() {
        long now = System.currentTimeMillis();
        long timeout = now - (long)(this.config.getRemoveAbandonedTimeout() * 1000);
        ArrayList<AbandonedTrace> remove = new ArrayList<AbandonedTrace>();
        List list = this.trace;
        synchronized (list) {
            for (AbandonedTrace pc : this.trace) {
                if (pc.getLastUsed() > timeout || pc.getLastUsed() <= 0L) continue;
                remove.add(pc);
            }
        }
        for (AbandonedTrace pc : remove) {
            if (this.config.getLogAbandoned()) {
                pc.printStackTrace();
            }
            try {
                this.invalidateObject(pc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

