/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.TryMakeTimestampExpressionBuilder$;
import org.apache.spark.sql.catalyst.plans.logical.FunctionSignature;
import scala.Function2;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@ExpressionDescription(usage="\n    _FUNC_(year, month, day, hour, min, sec[, timezone]) - Try to create a timestamp from year, month, day, hour, min, sec and timezone fields. The result data type is consistent with the value of configuration `spark.sql.timestampType`. The function returns NULL on invalid inputs.\n\n    _FUNC_(date[, time[, timezone]]) - Try to create a timestamp from date, time, and timezone fields.\n    ", arguments="\n    Arguments:\n      * year - the year to represent, from 1 to 9999\n      * month - the month-of-year to represent, from 1 (January) to 12 (December)\n      * day - the day-of-month to represent, from 1 to 31\n      * hour - the hour-of-day to represent, from 0 to 23\n      * min - the minute-of-hour to represent, from 0 to 59\n      * sec - the second-of-minute and its micro-fraction to represent, from 0 to 60.\n              The value can be either an integer like 13 , or a fraction like 13.123.\n              If the sec argument equals to 60, the seconds field is set\n              to 0 and 1 minute is added to the final timestamp.\n      * date - a date expression\n      * time - a time expression (optional). Default is 00:00:00.\n      * timezone - the time zone identifier (optional). For example, CET, UTC and etc.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(2014, 12, 28, 6, 30, 45.887);\n       2014-12-28 06:30:45.887\n      > SELECT _FUNC_(2014, 12, 28, 6, 30, 45.887, 'CET');\n       2014-12-27 21:30:45.887\n      > SELECT _FUNC_(DATE'2014-12-28');\n       2014-12-28 00:00:00\n      > SELECT _FUNC_(DATE'2014-12-28', TIME'6:30:45.887');\n       2014-12-28 06:30:45.887\n      > SELECT _FUNC_(DATE'2014-12-28', TIME'6:30:45.887', 'CET');\n       2014-12-27 21:30:45.887\n      > SELECT _FUNC_(2019, 6, 30, 23, 59, 60);\n       2019-07-01 00:00:00\n      > SELECT _FUNC_(2019, 6, 30, 23, 59, 1);\n       2019-06-30 23:59:01\n      > SELECT _FUNC_(null, 7, 22, 15, 30, 0);\n       NULL\n      > SELECT _FUNC_(2024, 13, 22, 15, 30, 0);\n       NULL\n  ", group="datetime_funcs", since="4.0.0")
@ScalaSignature(bytes="\u0006\u0005Q;Q\u0001B\u0003\t\u0002I1Q\u0001F\u0003\t\u0002UAQAI\u0001\u0005\u0002\rBQ\u0001J\u0001\u0005B\u0015\n\u0011\u0005\u0016:z\u001b\u0006\\W\rV5nKN$\u0018-\u001c9FqB\u0014Xm]:j_:\u0014U/\u001b7eKJT!AB\u0004\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u0011%\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u0015-\t1a]9m\u0015\taQ\"A\u0003ta\u0006\u00148N\u0003\u0002\u000f\u001f\u00051\u0011\r]1dQ\u0016T\u0011\u0001E\u0001\u0004_J<7\u0001\u0001\t\u0003'\u0005i\u0011!\u0002\u0002\")JLX*Y6f)&lWm\u001d;b[B,\u0005\u0010\u001d:fgNLwN\u001c\"vS2$WM]\n\u0004\u0003Ya\u0002CA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"AB!osJ+g\r\u0005\u0002\u001eA5\taD\u0003\u0002 \u000f\u0005A\u0011M\\1msNL7/\u0003\u0002\"=\t\tR\t\u001f9sKN\u001c\u0018n\u001c8Ck&dG-\u001a:\u0002\rqJg.\u001b;?)\u0005\u0011\u0012!\u00022vS2$Gc\u0001\u0014*mA\u00111cJ\u0005\u0003Q\u0015\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0011\u0015Q3\u00011\u0001,\u0003!1WO\\2OC6,\u0007C\u0001\u00174\u001d\ti\u0013\u0007\u0005\u0002/15\tqF\u0003\u00021#\u00051AH]8pizJ!A\r\r\u0002\rA\u0013X\rZ3g\u0013\t!TG\u0001\u0004TiJLgn\u001a\u0006\u0003eaAQAB\u0002A\u0002]\u00022\u0001O\u001f'\u001d\tI4H\u0004\u0002/u%\t\u0011$\u0003\u0002=1\u00059\u0001/Y2lC\u001e,\u0017B\u0001 @\u0005\r\u0019V-\u001d\u0006\u0003yaAC\"A!E\u000b\u001eC%jS'O!F\u0003\"a\u0005\"\n\u0005\r+!!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0002\r\u0006\u0019\tB\u0003\u0011!A\u0001zf)\u0016(D?\"JX-\u0019:-A5|g\u000e\u001e5-A\u0011\f\u0017\u0010\f\u0011i_V\u0014H\u0006I7j]2\u00023/Z2\\Y\u0001\"\u0018.\\3{_:,W,\u000b\u0011.AQ\u0013\u0018\u0010\t;pA\r\u0014X-\u0019;fA\u0005\u0004C/[7fgR\fW\u000e\u001d\u0011ge>l\u0007%_3be2\u0002Sn\u001c8uQ2\u0002C-Y=-A!|WO\u001d\u0017![&tG\u0006I:fG\u0002\ng\u000e\u001a\u0011uS6,'p\u001c8fA\u0019LW\r\u001c3t]\u0001\"\u0006.\u001a\u0011sKN,H\u000e\u001e\u0011eCR\f\u0007\u0005^=qK\u0002J7\u000fI2p]NL7\u000f^3oi\u0002:\u0018\u000e\u001e5!i\",\u0007E^1mk\u0016\u0004sN\u001a\u0011d_:4\u0017nZ;sCRLwN\u001c\u0011agB\f'o\u001b\u0018tc2tC/[7fgR\fW\u000e\u001d+za\u0016\u0004g\u0006\t+iK\u00022WO\\2uS>t\u0007E]3ukJt7\u000f\t(V\u00192\u0003sN\u001c\u0011j]Z\fG.\u001b3!S:\u0004X\u000f^:/\u0015)\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015eCR,7\f\f\u0011uS6,7\f\f\u0011uS6,'p\u001c8f;vK\u0003%\f\u0011Uef\u0004Co\u001c\u0011de\u0016\fG/\u001a\u0011bAQLW.Z:uC6\u0004\bE\u001a:p[\u0002\"\u0017\r^3-AQLW.\u001a\u0017!C:$\u0007\u0005^5nKj|g.\u001a\u0011gS\u0016dGm\u001d\u0018\u000bA\u0001\u0002\u0003%A\u0005be\u001e,X.\u001a8ug\u0006\n\u0011*\u0001D:\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u0002\u00130Z1sA5\u0002C\u000f[3!s\u0016\f'\u000f\t;pAI,\u0007O]3tK:$H\u0006\t4s_6\u0004\u0013\u0007\t;pAeJ\u0014(\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016![>tG\u000f\u001b\u0011.AQDW\rI7p]RDWf\u001c4.s\u0016\f'\u000f\t;pAI,\u0007O]3tK:$H\u0006\t4s_6\u0004\u0013\u0007\t\u0015KC:,\u0018M]=*AQ|\u0007%\r\u001a!Q\u0011+7-Z7cKJL#\u0002\t\u0011!A\u0001\u0002#\u0006\t3bs\u0002j\u0003\u0005\u001e5fA\u0011\f\u00170L8g[5|g\u000e\u001e5!i>\u0004#/\u001a9sKN,g\u000e\u001e\u0017!MJ|W\u000eI\u0019!i>\u00043'\r\u0006!A\u0001\u0002\u0003\u0005\t\u0016!Q>,(\u000fI\u0017!i\",\u0007\u0005[8ve6zg-\f3bs\u0002\"x\u000e\t:faJ,7/\u001a8uY\u00012'o\\7!a\u0001\"x\u000e\t\u001a4\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001j\u0017N\u001c\u0011.AQDW\rI7j]V$X-L8g[!|WO\u001d\u0011u_\u0002\u0012X\r\u001d:fg\u0016tG\u000f\f\u0011ge>l\u0007\u0005\r\u0011u_\u0002*\u0014H\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011tK\u000e\u0004S\u0006\t;iK\u0002\u001aXmY8oI6zg-L7j]V$X\rI1oI\u0002JGo\u001d\u0011nS\u000e\u0014x.\f4sC\u000e$\u0018n\u001c8!i>\u0004#/\u001a9sKN,g\u000e\u001e\u0017!MJ|W\u000e\t\u0019!i>\u0004c\u0007\r\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!)\",\u0007E^1mk\u0016\u00043-\u00198!E\u0016\u0004S-\u001b;iKJ\u0004\u0013M\u001c\u0011j]R,w-\u001a:!Y&\\W\rI\u00194A1\u0002sN\u001d\u0011bA\u0019\u0014\u0018m\u0019;j_:\u0004C.[6fAE\u001ad&\r\u001a4])\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001Je\r\t;iK\u0002\u001aXm\u0019\u0011be\u001e,X.\u001a8uA\u0015\fX/\u00197tAQ|\u0007E\u000e\u0019-AQDW\rI:fG>tGm\u001d\u0011gS\u0016dG\rI5tAM,GO\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t;pAA\u0002\u0013M\u001c3!c\u0001j\u0017N\\;uK\u0002J7\u000fI1eI\u0016$\u0007\u0005^8!i\",\u0007EZ5oC2\u0004C/[7fgR\fW\u000e\u001d\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011+A\u0011\fG/\u001a\u0011.A\u0005\u0004C-\u0019;fA\u0015D\bO]3tg&|gN\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011uS6,\u0007%\f\u0011bAQLW.\u001a\u0011fqB\u0014Xm]:j_:\u0004\u0003f\u001c9uS>t\u0017\r\\\u0015/A\u0011+g-Y;mi\u0002J7\u000f\t\u00191uA\u0002$\b\r\u0019/\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\"\u0018.\\3{_:,\u0007%\f\u0011uQ\u0016\u0004C/[7fAi|g.\u001a\u0011jI\u0016tG/\u001b4jKJ\u0004\u0003f\u001c9uS>t\u0017\r\\\u0015/A\u0019{'\u000fI3yC6\u0004H.\u001a\u0017!\u0007\u0016#F\u0006I+U\u0007\u0002\ng\u000e\u001a\u0011fi\u000et#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f\u0013\u0001T\u0001\u0006\u0018*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C#\u0007M\u00195Y\u0001\n$\u0007\f\u00113q1\u0002c\u0007\f\u00114a1\u0002C'\u000e\u00189q]J3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001a1cQj\u0013GM\u00173q\u0001\u0002dGO\u001a1uQ*d\u0006\u000f\u001d8\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\u0012\u0004'\r\u001b-AE\u0012D\u0006\t\u001a9Y\u00012D\u0006I\u001a1Y\u0001\"TG\f\u001d9o1\u0002seQ#UO%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\r\u00192i5\n$'\f\u001a8AI\n$h\r\u0019;iUr\u0003\bO\u001c\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u0011\u000bE+R\u00143aE\"T&\r\u001a.ea:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113aE\"T&\r\u001a.ea\u0002\u0003\u0007\r\u001e1ai\u0002\u0004G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015E\u0003R+uE\r\u00192i5\n$'\f\u001a9O1\u0002C+S'FOYR4\u0007\r\u001e5k9B\u0004hN\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012\u0004'\r\u001b.cIj#\u0007\u000f\u00111mi\u001a\u0004G\u000f\u001b6]aBtG\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015E\u0003R+uE\r\u00192i5\n$'\f\u001a9O1\u0002C+S'FOYR4\u0007\r\u001e5k9B\u0004hN\u0014-A\u001d\u001aU\tV\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012\u0004'\r\u001b.cIj#g\u000e\u00113ci\u001a\u0004G\u000f\u001b6]aBtG\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u00153aEJD\u0006\t\u001c-AM\u0002D\u0006\t\u001a4Y\u0001*\u0014\b\f\u00117a%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\r\u00192s5\u0002t'\f\u00192AA\u0002$\b\r\u0019;aAR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006F\r\u00192s1\u0002c\u0007\f\u00114a1\u0002#g\r\u0017!keb\u0003%M\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AI\u0002\u0014'O\u00171m5\u001a\u0004\u0007\t\u001a4uUJ$\bM\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q9,H\u000e\u001c\u0017!o1\u0002#G\r\u0017!cUb\u0003e\r\u0019-AAJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t(V\u00192S\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006F\r\u00193i1\u0002\u0013g\r\u0017!eIb\u0003%M\u001b-AM\u0002D\u0006\t\u0019*w)\u0001\u0003\u0005\t\u0011!A\u0001rU\u000b\u0014'\u000bA\u0001\nQa\u001a:pkB\f\u0013aT\u0001\u000fI\u0006$X\r^5nK~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\u0005\u0011\u0016!\u0002\u001b/a9\u0002\u0004\u0006\u0004\u0001B\t\u0016;\u0005JS&N\u001dB\u000b\u0006")
public final class TryMakeTimestampExpressionBuilder {
    public static Expression build(String funcName, Seq<Expression> expressions) {
        return TryMakeTimestampExpressionBuilder$.MODULE$.build(funcName, (Seq)expressions);
    }

    public static boolean supportsLambda() {
        return TryMakeTimestampExpressionBuilder$.MODULE$.supportsLambda();
    }

    public static Seq<Expression> rearrange(FunctionSignature expectedSignature, Seq<Expression> providedArguments, String functionName, Function2<String, String, Object> resolver) {
        return TryMakeTimestampExpressionBuilder$.MODULE$.rearrange(expectedSignature, providedArguments, functionName, resolver);
    }

    public static Option<FunctionSignature> functionSignature() {
        return TryMakeTimestampExpressionBuilder$.MODULE$.functionSignature();
    }
}

