% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/functions.R
\name{column_window_functions}
\alias{column_window_functions}
\alias{cume_dist,missing-method}
\alias{cume_dist}
\alias{dense_rank,missing-method}
\alias{dense_rank}
\alias{lag,characterOrColumn-method}
\alias{lag}
\alias{lead,characterOrColumn,numeric-method}
\alias{lead}
\alias{nth_value,characterOrColumn,numeric-method}
\alias{nth_value}
\alias{nth_value,characterOrColumn-method}
\alias{ntile,numeric-method}
\alias{ntile}
\alias{percent_rank,missing-method}
\alias{percent_rank}
\alias{rank,missing-method}
\alias{rank}
\alias{rank,ANY-method}
\alias{row_number,missing-method}
\alias{row_number}
\title{Window functions for Column operations}
\usage{
cume_dist(x = "missing")

dense_rank(x = "missing")

lag(x, ...)

lead(x, offset, defaultValue = NULL)

nth_value(x, offset, ...)

ntile(x)

percent_rank(x = "missing")

rank(x, ...)

row_number(x = "missing")

\S4method{cume_dist}{missing}()

\S4method{dense_rank}{missing}()

\S4method{lag}{characterOrColumn}(x, offset = 1, defaultValue = NULL)

\S4method{lead}{characterOrColumn,numeric}(x, offset = 1, defaultValue = NULL)

\S4method{nth_value}{characterOrColumn,numeric}(x, offset, na.rm = FALSE)

\S4method{ntile}{numeric}(x)

\S4method{percent_rank}{missing}()

\S4method{rank}{missing}()

\S4method{rank}{ANY}(x, ...)

\S4method{row_number}{missing}()
}
\arguments{
\item{x}{In \code{lag} and \code{lead}, it is the column as a character string or a Column
to compute on. In \code{ntile}, it is the number of ntile groups.}

\item{...}{additional argument(s).}

\item{offset}{a numeric indicating number of row to use as the value}

\item{defaultValue}{(optional) default to use when the offset row does not exist.}

\item{na.rm}{a logical which indicates that the Nth value should skip null in the
determination of which row to use}
}
\description{
Window functions defined for \code{Column}.
}
\details{
\code{cume_dist}: Returns the cumulative distribution of values within a window partition,
i.e. the fraction of rows that are below the current row:
(number of values before and including x) / (total number of rows in the partition).
This is equivalent to the \code{CUME_DIST} function in SQL.
The method should be used with no argument.

\code{dense_rank}: Returns the rank of rows within a window partition, without any gaps.
The difference between rank and dense_rank is that dense_rank leaves no gaps in ranking
sequence when there are ties. That is, if you were ranking a competition using dense_rank
and had three people tie for second place, you would say that all three were in second
place and that the next person came in third. Rank would give me sequential numbers, making
the person that came in third place (after the ties) would register as coming in fifth.
This is equivalent to the \code{DENSE_RANK} function in SQL.
The method should be used with no argument.

\code{lag}: Returns the value that is \code{offset} rows before the current row, and
\code{defaultValue} if there is less than \code{offset} rows before the current row. For example,
an \code{offset} of one will return the previous row at any given point in the window partition.
This is equivalent to the \code{LAG} function in SQL.

\code{lead}: Returns the value that is \code{offset} rows after the current row, and
\code{defaultValue} if there is less than \code{offset} rows after the current row.
For example, an \code{offset} of one will return the next row at any given point
in the window partition.
This is equivalent to the \code{LEAD} function in SQL.

\code{nth_value}: Window function: returns the value that is the \code{offset}th
row of the window frame# (counting from 1), and \code{null} if the size of window
frame is less than \code{offset} rows.

\code{ntile}: Returns the ntile group id (from 1 to n inclusive) in an ordered window
partition. For example, if n is 4, the first quarter of the rows will get value 1, the second
quarter will get 2, the third quarter will get 3, and the last quarter will get 4.
This is equivalent to the \code{NTILE} function in SQL.

\code{percent_rank}: Returns the relative rank (i.e. percentile) of rows within a window
partition.
This is computed by: (rank of row in its partition - 1) / (number of rows in the partition - 1).
This is equivalent to the \code{PERCENT_RANK} function in SQL.
The method should be used with no argument.

\code{rank}: Returns the rank of rows within a window partition.
The difference between rank and dense_rank is that dense_rank leaves no gaps in ranking
sequence when there are ties. That is, if you were ranking a competition using dense_rank
and had three people tie for second place, you would say that all three were in second
place and that the next person came in third. Rank would give me sequential numbers, making
the person that came in third place (after the ties) would register as coming in fifth.
This is equivalent to the \code{RANK} function in SQL.
The method should be used with no argument.

\code{row_number}: Returns a sequential number starting at 1 within a window partition.
This is equivalent to the \code{ROW_NUMBER} function in SQL.
The method should be used with no argument.
}
\note{
cume_dist since 1.6.0

dense_rank since 1.6.0

lag since 1.6.0

lead since 1.6.0

nth_value since 3.1.0

ntile since 1.6.0

percent_rank since 1.6.0

rank since 1.6.0

row_number since 1.6.0
}
\examples{
\dontrun{
# Dataframe used throughout this doc
df <- createDataFrame(cbind(model = rownames(mtcars), mtcars))
ws <- orderBy(windowPartitionBy("am"), "hp")
tmp <- mutate(df, dist = over(cume_dist(), ws), dense_rank = over(dense_rank(), ws),
              lag = over(lag(df$mpg), ws), lead = over(lead(df$mpg, 1), ws),
              percent_rank = over(percent_rank(), ws),
              rank = over(rank(), ws), row_number = over(row_number(), ws),
              nth_value = over(nth_value(df$mpg, 3), ws))
# Get ntile group id (1-4) for hp
tmp <- mutate(tmp, ntile = over(ntile(4), ws))
head(tmp)}
}
\concept{window functions}
