/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.SubstringIndex$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str, delim, count) - Returns the substring from `str` before `count` occurrences of the delimiter `delim`.\n      If `count` is positive, everything to the left of the final delimiter (counting from the\n      left) is returned. If `count` is negative, everything to the right of the final delimiter\n      (counting from the right) is returned. The function substring_index performs a case-sensitive match\n      when searching for `delim`.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('www.apache.org', '.', 2);\n       www.apache\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0001\t\u0015a\u0001\u0002\u0012$\u0001BB\u0001\u0002\u0013\u0001\u0003\u0016\u0004%\t!\u0013\u0005\t\u001b\u0002\u0011\t\u0012)A\u0005\u0015\"Aa\n\u0001BK\u0002\u0013\u0005\u0011\n\u0003\u0005P\u0001\tE\t\u0015!\u0003K\u0011!\u0001\u0006A!f\u0001\n\u0003I\u0005\u0002C)\u0001\u0005#\u0005\u000b\u0011\u0002&\t\u000bI\u0003A\u0011A*\t\u000ba\u0003A\u0011I-\t\u000b\u0001\u0004A\u0011I1\t\u000b5\u0004A\u0011I%\t\u000b9\u0004A\u0011I%\t\u000b=\u0004A\u0011I%\t\u000bA\u0004A\u0011I9\t\u000bi\u0004A\u0011I>\t\u000f\u0005-\u0001\u0001\"\u0011\u0002\u000e!9\u0011\u0011\u0006\u0001\u0005R\u0005-\u0002\"CA\u001d\u0001\u0005\u0005I\u0011AA\u001e\u0011%\t\u0019\u0005AI\u0001\n\u0003\t)\u0005C\u0005\u0002\\\u0001\t\n\u0011\"\u0001\u0002F!I\u0011Q\f\u0001\u0012\u0002\u0013\u0005\u0011Q\t\u0005\n\u0003?\u0002\u0011\u0011!C!\u0003CB\u0011\"!\u001d\u0001\u0003\u0003%\t!a\u001d\t\u0013\u0005m\u0004!!A\u0005\u0002\u0005u\u0004\"CAB\u0001\u0005\u0005I\u0011IAC\u0011%\t\u0019\nAA\u0001\n\u0003\t)\nC\u0005\u0002 \u0002\t\t\u0011\"\u0011\u0002\"\u001eI\u0011QY\u0012\u0002\u0002#\u0005\u0011q\u0019\u0004\tE\r\n\t\u0011#\u0001\u0002J\"1!\u000b\bC\u0001\u0003/D\u0011\"!7\u001d\u0003\u0003%)%a7\t\u0013\u0005uG$!A\u0005\u0002\u0006}\u0007\"CAt9\u0005\u0005I\u0011QAu\u0011%\tY\u0010HA\u0001\n\u0013\tiP\u0001\bTk\n\u001cHO]5oO&sG-\u001a=\u000b\u0005\u0011*\u0013aC3yaJ,7o]5p]NT!AJ\u0014\u0002\u0011\r\fG/\u00197zgRT!\u0001K\u0015\u0002\u0007M\fHN\u0003\u0002+W\u0005)1\u000f]1sW*\u0011A&L\u0001\u0007CB\f7\r[3\u000b\u00039\n1a\u001c:h\u0007\u0001\u0019b\u0001A\u00196q}*\u0005C\u0001\u001a4\u001b\u0005\u0019\u0013B\u0001\u001b$\u0005E!VM\u001d8bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003eYJ!aN\u0012\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"!\u000f\u001f\u000f\u0005IR\u0014BA\u001e$\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0010 \u0003\u001d9+H\u000e\\%oi>dWM]1oi*\u00111h\t\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0002\u0005\u0006)1oY1mC&\u0011A)\u0011\u0002\b!J|G-^2u!\t\u0001e)\u0003\u0002H\u0003\na1+\u001a:jC2L'0\u00192mK\u000691\u000f\u001e:FqB\u0014X#\u0001&\u0011\u0005IZ\u0015B\u0001'$\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\tgR\u0014X\t\u001f9sA\u0005IA-\u001a7j[\u0016C\bO]\u0001\u000bI\u0016d\u0017.\\#yaJ\u0004\u0013!C2pk:$X\t\u001f9s\u0003)\u0019w.\u001e8u\u000bb\u0004(\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\tQ+fk\u0016\t\u0003e\u0001AQ\u0001S\u0004A\u0002)CQAT\u0004A\u0002)CQ\u0001U\u0004A\u0002)\u000b\u0001\u0002Z1uCRK\b/Z\u000b\u00025B\u00111LX\u0007\u00029*\u0011QlJ\u0001\u0006if\u0004Xm]\u0005\u0003?r\u0013\u0001\u0002R1uCRK\b/Z\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#\u00012\u0011\u0007\rT'L\u0004\u0002eS:\u0011Q\r[\u0007\u0002M*\u0011qmL\u0001\u0007yI|w\u000e\u001e \n\u0003\tK!aO!\n\u0005-d'aA*fc*\u00111(Q\u0001\u0006M&\u00148\u000f^\u0001\u0007g\u0016\u001cwN\u001c3\u0002\u000bQD\u0017N\u001d3\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001s!\t\u0019xO\u0004\u0002ukB\u0011Q-Q\u0005\u0003m\u0006\u000ba\u0001\u0015:fI\u00164\u0017B\u0001=z\u0005\u0019\u0019FO]5oO*\u0011a/Q\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0007y~\f\u0019!a\u0002\u0011\u0005\u0001k\u0018B\u0001@B\u0005\r\te.\u001f\u0005\u0007\u0003\u0003q\u0001\u0019\u0001?\u0002\u0007M$(\u000f\u0003\u0004\u0002\u00069\u0001\r\u0001`\u0001\u0006I\u0016d\u0017.\u001c\u0005\u0007\u0003\u0013q\u0001\u0019\u0001?\u0002\u000b\r|WO\u001c;\u0002\u0013\u0011|w)\u001a8D_\u0012,GCBA\b\u00037\t)\u0003\u0005\u0003\u0002\u0012\u0005]QBAA\n\u0015\r\t)bI\u0001\bG>$WmZ3o\u0013\u0011\tI\"a\u0005\u0003\u0011\u0015C\bO]\"pI\u0016Dq!!\b\u0010\u0001\u0004\ty\"A\u0002dib\u0004B!!\u0005\u0002\"%!\u00111EA\n\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDq!a\n\u0010\u0001\u0004\ty!\u0001\u0002fm\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\b)\u00065\u0012\u0011GA\u001b\u0011\u0019\ty\u0003\u0005a\u0001\u0015\u0006Aa.Z<GSJ\u001cH\u000f\u0003\u0004\u00024A\u0001\rAS\u0001\n]\u0016<8+Z2p]\u0012Da!a\u000e\u0011\u0001\u0004Q\u0015\u0001\u00038foRC\u0017N\u001d3\u0002\t\r|\u0007/\u001f\u000b\b)\u0006u\u0012qHA!\u0011\u001dA\u0015\u0003%AA\u0002)CqAT\t\u0011\u0002\u0003\u0007!\nC\u0004Q#A\u0005\t\u0019\u0001&\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\t\u0016\u0004\u0015\u0006%3FAA&!\u0011\ti%a\u0016\u000e\u0005\u0005=#\u0002BA)\u0003'\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005U\u0013)\u0001\u0006b]:|G/\u0019;j_:LA!!\u0017\u0002P\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002dA!\u0011QMA8\u001b\t\t9G\u0003\u0003\u0002j\u0005-\u0014\u0001\u00027b]\u001eT!!!\u001c\u0002\t)\fg/Y\u0005\u0004q\u0006\u001d\u0014\u0001\u00049s_\u0012,8\r^!sSRLXCAA;!\r\u0001\u0015qO\u0005\u0004\u0003s\n%aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$Hc\u0001?\u0002\u0000!I\u0011\u0011Q\f\u0002\u0002\u0003\u0007\u0011QO\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\u001d\u0005#BAE\u0003\u001fcXBAAF\u0015\r\ti)Q\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAI\u0003\u0017\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011qSAO!\r\u0001\u0015\u0011T\u0005\u0004\u00037\u000b%a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003\u0003K\u0012\u0011!a\u0001y\u00061Q-];bYN$B!a&\u0002$\"A\u0011\u0011\u0011\u000e\u0002\u0002\u0003\u0007A\u0010K\n\u0001\u0003O\u000bi+a,\u00024\u0006U\u0016\u0011XA^\u0003\u007f\u000b\t\rE\u00023\u0003SK1!a+$\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!-\u0002\u0007\u0013S\u0001\u0005\t\u0011!?\u001a+fjQ0)gR\u0014H\u0006\t3fY&lG\u0006I2pk:$\u0018\u0006I\u0017!%\u0016$XO\u001d8tAQDW\rI:vEN$(/\u001b8hA\u0019\u0014x.\u001c\u0011agR\u0014\b\r\t2fM>\u0014X\r\t1d_VtG\u000f\u0019\u0011pG\u000e,(O]3oG\u0016\u001c\be\u001c4!i\",\u0007\u0005Z3mS6LG/\u001a:!A\u0012,G.[7a])\u0001\u0003\u0005\t\u0011!A%3\u0007\u0005Y2pk:$\b\rI5tAA|7/\u001b;jm\u0016d\u0003%\u001a<fef$\b.\u001b8hAQ|\u0007\u0005\u001e5fA1,g\r\u001e\u0011pM\u0002\"\b.\u001a\u0011gS:\fG\u000e\t3fY&l\u0017\u000e^3sA!\u001aw.\u001e8uS:<\u0007E\u001a:p[\u0002\"\b.\u001a\u0006!A\u0001\u0002\u0003\u0005\t7fMRL\u0003%[:!e\u0016$XO\u001d8fI:\u0002\u0013J\u001a\u0011aG>,h\u000e\u001e1!SN\u0004c.Z4bi&4X\r\f\u0011fm\u0016\u0014\u0018\u0010\u001e5j]\u001e\u0004Co\u001c\u0011uQ\u0016\u0004#/[4ii\u0002zg\r\t;iK\u00022\u0017N\\1mA\u0011,G.[7ji\u0016\u0014(\u0002\t\u0011!A\u0001\u0002\u0003fY8v]RLgn\u001a\u0011ge>l\u0007\u0005\u001e5fAILw\r\u001b;*A%\u001c\bE]3ukJtW\r\u001a\u0018!)\",\u0007EZ;oGRLwN\u001c\u0011tk\n\u001cHO]5oO~Kg\u000eZ3yAA,'OZ8s[N\u0004\u0013\rI2bg\u0016l3/\u001a8tSRLg/\u001a\u0011nCR\u001c\u0007N\u0003\u0011!A\u0001\u0002\u0003e\u001e5f]\u0002\u001aX-\u0019:dQ&tw\r\t4pe\u0002\u0002G-\u001a7j[\u0002t#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a.\u0002)*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cse^<x]\u0005\u0004\u0018m\u00195f]=\u0014xm\n\u0017!O9:C\u0006\t\u001a*w)\u0001\u0003\u0005\t\u0011!A\u0001:xo\u001e\u0018ba\u0006\u001c\u0007.\u001a\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u0011QX\u0001\u0006c9*d\u0006M\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003\u0007\fAb\u001d;sS:<wLZ;oGN\fabU;cgR\u0014\u0018N\\4J]\u0012,\u0007\u0010\u0005\u000239M!A$a3F!!\ti-a5K\u0015*#VBAAh\u0015\r\t\t.Q\u0001\beVtG/[7f\u0013\u0011\t).a4\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007\u0006\u0002\u0002H\u0006AAo\\*ue&tw\r\u0006\u0002\u0002d\u0005)\u0011\r\u001d9msR9A+!9\u0002d\u0006\u0015\b\"\u0002% \u0001\u0004Q\u0005\"\u0002( \u0001\u0004Q\u0005\"\u0002) \u0001\u0004Q\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0003W\f9\u0010E\u0003A\u0003[\f\t0C\u0002\u0002p\u0006\u0013aa\u00149uS>t\u0007C\u0002!\u0002t*S%*C\u0002\u0002v\u0006\u0013a\u0001V;qY\u0016\u001c\u0004\u0002CA}A\u0005\u0005\t\u0019\u0001+\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GCAA\u0000!\u0011\t)G!\u0001\n\t\t\r\u0011q\r\u0002\u0007\u001f\nTWm\u0019;")
public class SubstringIndex
extends TernaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression strExpr;
    private final Expression delimExpr;
    private final Expression countExpr;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(SubstringIndex substringIndex) {
        return SubstringIndex$.MODULE$.unapply(substringIndex);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, SubstringIndex> tupled() {
        return SubstringIndex$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, SubstringIndex>>> curried() {
        return SubstringIndex$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression strExpr() {
        return this.strExpr;
    }

    public Expression delimExpr() {
        return this.delimExpr;
    }

    public Expression countExpr() {
        return this.countExpr;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$)));
    }

    @Override
    public Expression first() {
        return this.strExpr();
    }

    @Override
    public Expression second() {
        return this.delimExpr();
    }

    @Override
    public Expression third() {
        return this.countExpr();
    }

    @Override
    public String prettyName() {
        return "substring_index";
    }

    @Override
    public Object nullSafeEval(Object str, Object delim, Object count) {
        return ((UTF8String)str).subStringIndex((UTF8String)delim, BoxesRunTime.unboxToInt((Object)count));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable & scala.Serializable)(str, delim, count) -> new StringBuilder(19).append((String)str).append(".subStringIndex(").append((String)delim).append(", ").append((String)count).append(")").toString());
    }

    @Override
    public SubstringIndex withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public SubstringIndex copy(Expression strExpr, Expression delimExpr, Expression countExpr) {
        return new SubstringIndex(strExpr, delimExpr, countExpr);
    }

    public Expression copy$default$1() {
        return this.strExpr();
    }

    public Expression copy$default$2() {
        return this.delimExpr();
    }

    public Expression copy$default$3() {
        return this.countExpr();
    }

    @Override
    public String productPrefix() {
        return "SubstringIndex";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.strExpr();
            }
            case 1: {
                return this.delimExpr();
            }
            case 2: {
                return this.countExpr();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SubstringIndex;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SubstringIndex)) return false;
        boolean bl = true;
        if (!bl) return false;
        SubstringIndex substringIndex = (SubstringIndex)x$1;
        Expression expression = this.strExpr();
        Expression expression2 = substringIndex.strExpr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.delimExpr();
        Expression expression4 = substringIndex.delimExpr();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.countExpr();
        Expression expression6 = substringIndex.countExpr();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!substringIndex.canEqual(this)) return false;
        return true;
    }

    public SubstringIndex(Expression strExpr, Expression delimExpr, Expression countExpr) {
        this.strExpr = strExpr;
        this.delimExpr = delimExpr;
        this.countExpr = countExpr;
        ExpectsInputTypes.$init$(this);
    }
}

