/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.mllib.SampledRDDs;
import org.apache.spark.examples.mllib.SampledRDDs$Params$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.PairRDDFunctions;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.sys.package$;
import scopt.OptionParser;
import scopt.Read$;

public final class SampledRDDs$ {
    public static SampledRDDs$ MODULE$;

    static {
        new SampledRDDs$();
    }

    public void main(String[] args) {
        SampledRDDs.Params defaultParams = new SampledRDDs.Params(SampledRDDs$Params$.MODULE$.apply$default$1());
        OptionParser<SampledRDDs.Params> parser = new OptionParser<SampledRDDs.Params>(defaultParams){
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SampledRDDs: an example app for randomly generated and sampled RDDs."}));
                this.opt("input", Read$.MODULE$.stringRead()).text(new StringBuilder(58).append("Input path to labeled examples in LIBSVM format, default: ").append(defaultParams$1.input()).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> c.copy((String)x));
                this.note(new StringOps(Predef$.MODULE$.augmentString("\n        |For example, the following command runs this app:\n        |\n        | bin/spark-submit --class org.apache.spark.examples.mllib.SampledRDDs \\\n        |  examples/target/scala-*/spark-examples-*.jar\n        ")).stripMargin());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$new$1(java.lang.String org.apache.spark.examples.mllib.SampledRDDs$Params )}, serializedLambda);
            }
        };
        Option option = parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)defaultParams);
        if (option instanceof Some) {
            Some some = (Some)option;
            SampledRDDs.Params params = (SampledRDDs.Params)some.value();
            this.run(params);
            return;
        }
        throw package$.MODULE$.exit(1);
    }

    public void run(SampledRDDs.Params params) {
        SparkConf conf = new SparkConf().setAppName(new StringBuilder(17).append("SampledRDDs with ").append(params).toString());
        SparkContext sc = new SparkContext(conf);
        double fraction = 0.1;
        RDD examples = MLUtils$.MODULE$.loadLibSVMFile(sc, params.input());
        long numExamples = examples.count();
        if (numExamples == 0L) {
            throw new RuntimeException("Error: Data file had no samples to load.");
        }
        Predef$.MODULE$.println((Object)new StringBuilder(38).append("Loaded data with ").append(numExamples).append(" examples from file: ").append(params.input()).toString());
        int expectedSampleSize = (int)((double)numExamples * fraction);
        Predef$.MODULE$.println((Object)new StringBuilder(55).append("Sampling RDD using fraction ").append(fraction).append(".  Expected sample size = ").append(expectedSampleSize).append(".").toString());
        RDD sampledRDD = examples.sample(true, fraction, examples.sample$default$3());
        Predef$.MODULE$.println((Object)new StringBuilder(36).append("  RDD.sample(): sample has ").append(sampledRDD.count()).append(" examples").toString());
        LabeledPoint[] sampledArray = (LabeledPoint[])examples.takeSample(true, expectedSampleSize, examples.takeSample$default$3());
        Predef$.MODULE$.println((Object)new StringBuilder(40).append("  RDD.takeSample(): sample has ").append(sampledArray.length).append(" examples").toString());
        Predef$.MODULE$.println();
        RDD keyedRDD = examples.map((Function1 & Serializable & scala.Serializable)lp -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)((int)lp.label())), (Object)lp.features()), ClassTag$.MODULE$.apply(Tuple2.class));
        Predef$.MODULE$.println((Object)"  Keyed data using label (Int) as key ==> Orig");
        Map keyCounts = RDD$.MODULE$.rddToPairRDDFunctions(keyedRDD, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Vector.class), (Ordering)Ordering.Int$.MODULE$).countByKey();
        scala.collection.immutable.Map fractions = ((TraversableOnce)keyCounts.keys().map((Function1 & Serializable & scala.Serializable)x$1 -> SampledRDDs$.$anonfun$run$2(fraction, BoxesRunTime.unboxToInt((Object)x$1)), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        PairRDDFunctions qual$1 = RDD$.MODULE$.rddToPairRDDFunctions(keyedRDD, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Vector.class), (Ordering)Ordering.Int$.MODULE$);
        boolean x$12 = true;
        scala.collection.immutable.Map x$2 = fractions;
        long x$3 = qual$1.sampleByKey$default$3();
        RDD sampledByKeyRDD = qual$1.sampleByKey(x$12, (Map)x$2, x$3);
        Map keyCountsB = RDD$.MODULE$.rddToPairRDDFunctions(sampledByKeyRDD, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Vector.class), (Ordering)Ordering.Int$.MODULE$).countByKey();
        long sizeB = BoxesRunTime.unboxToLong((Object)keyCountsB.values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        Predef$.MODULE$.println((Object)new StringBuilder(87).append("  Sampled ").append(sizeB).append(" examples using approximate stratified sampling (by label).").append(" ==> Approx Sample").toString());
        PairRDDFunctions qual$2 = RDD$.MODULE$.rddToPairRDDFunctions(keyedRDD, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Vector.class), (Ordering)Ordering.Int$.MODULE$);
        boolean x$4 = true;
        scala.collection.immutable.Map x$5 = fractions;
        long x$6 = qual$2.sampleByKeyExact$default$3();
        RDD sampledByKeyRDDExact = qual$2.sampleByKeyExact(x$4, (Map)x$5, x$6);
        Map keyCountsBExact = RDD$.MODULE$.rddToPairRDDFunctions(sampledByKeyRDDExact, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Vector.class), (Ordering)Ordering.Int$.MODULE$).countByKey();
        long sizeBExact = BoxesRunTime.unboxToLong((Object)keyCountsBExact.values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        Predef$.MODULE$.println((Object)new StringBuilder(80).append("  Sampled ").append(sizeBExact).append(" examples using exact stratified sampling (by label).").append(" ==> Exact Sample").toString());
        Predef$.MODULE$.println((Object)"   \tFractions of examples with key");
        Predef$.MODULE$.println((Object)"Key\tOrig\tApprox Sample\tExact Sample");
        ((IterableLike)keyCounts.keys().toSeq().sorted((Ordering)Ordering.Int$.MODULE$)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)key -> {
            double origFrac = (double)BoxesRunTime.unboxToLong((Object)keyCounts.apply((Object)BoxesRunTime.boxToInteger((int)key))) / (double)numExamples;
            double approxFrac = sizeB != 0L ? (double)BoxesRunTime.unboxToLong((Object)keyCountsB.getOrElse((Object)BoxesRunTime.boxToInteger((int)key), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)) / (double)sizeB : 0.0;
            double exactFrac = sizeBExact != 0L ? (double)BoxesRunTime.unboxToLong((Object)keyCountsBExact.getOrElse((Object)BoxesRunTime.boxToInteger((int)key), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)) / (double)sizeBExact : 0.0;
            Predef$.MODULE$.println((Object)new StringBuilder(3).append(key).append("\t").append(origFrac).append("\t").append(approxFrac).append("\t").append(exactFrac).toString());
        });
        sc.stop();
    }

    public static final /* synthetic */ Tuple2 $anonfun$run$2(double fraction$1, int x$1) {
        return new Tuple2.mcID.sp(x$1, fraction$1);
    }

    private SampledRDDs$() {
        MODULE$ = this;
    }
}

