/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.evaluation.MultilabelMetrics;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.java8.JFunction1;

public final class MultiLabelMetricsExample$ {
    public static MultiLabelMetricsExample$ MODULE$;

    static {
        new MultiLabelMetricsExample$();
    }

    public void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("MultiLabelMetricsExample");
        SparkContext sc = new SparkContext(conf);
        RDD scoreAndLabels = sc.parallelize((Seq)new .colon.colon((Object)new Tuple2((Object)new double[]{0.0, 1.0}, (Object)new double[]{0.0, 2.0}), (List)new .colon.colon((Object)new Tuple2((Object)new double[]{0.0, 2.0}, (Object)new double[]{0.0, 1.0}), (List)new .colon.colon((Object)new Tuple2(Array$.MODULE$.empty(ClassTag$.MODULE$.Double()), (Object)new double[]{0.0}), (List)new .colon.colon((Object)new Tuple2((Object)new double[]{2.0}, (Object)new double[]{2.0}), (List)new .colon.colon((Object)new Tuple2((Object)new double[]{2.0, 0.0}, (Object)new double[]{2.0, 0.0}), (List)new .colon.colon((Object)new Tuple2((Object)new double[]{0.0, 1.0, 2.0}, (Object)new double[]{0.0, 1.0}), (List)new .colon.colon((Object)new Tuple2((Object)new double[]{1.0}, (Object)new double[]{1.0, 2.0}), (List)Nil$.MODULE$))))))), 2, ClassTag$.MODULE$.apply(Tuple2.class));
        MultilabelMetrics metrics = new MultilabelMetrics(scoreAndLabels);
        Predef$.MODULE$.println((Object)new StringBuilder(9).append("Recall = ").append(metrics.recall()).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(12).append("Precision = ").append(metrics.precision()).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(13).append("F1 measure = ").append(metrics.f1Measure()).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(11).append("Accuracy = ").append(metrics.accuracy()).toString());
        new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(metrics.labels())).foreach((Function1)(JFunction1.mcVD.sp & java.io.Serializable & Serializable)label -> Predef$.MODULE$.println((Object)new StringBuilder(19).append("Class ").append(label).append(" precision = ").append(metrics.precision(label)).toString()));
        new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(metrics.labels())).foreach((Function1)(JFunction1.mcVD.sp & java.io.Serializable & Serializable)label -> Predef$.MODULE$.println((Object)new StringBuilder(16).append("Class ").append(label).append(" recall = ").append(metrics.recall(label)).toString()));
        new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(metrics.labels())).foreach((Function1)(JFunction1.mcVD.sp & java.io.Serializable & Serializable)label -> Predef$.MODULE$.println((Object)new StringBuilder(18).append("Class ").append(label).append(" F1-score = ").append(metrics.f1Measure(label)).toString()));
        Predef$.MODULE$.println((Object)new StringBuilder(15).append("Micro recall = ").append(metrics.microRecall()).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(18).append("Micro precision = ").append(metrics.microPrecision()).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(19).append("Micro F1 measure = ").append(metrics.microF1Measure()).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(15).append("Hamming loss = ").append(metrics.hammingLoss()).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(18).append("Subset accuracy = ").append(metrics.subsetAccuracy()).toString());
        sc.stop();
    }

    private MultiLabelMetricsExample$() {
        MODULE$ = this;
    }
}

