/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.observation;

import java.io.Closeable;
import java.util.concurrent.Executor;
import org.apache.jackrabbit.oak.plugins.observation.Filter;
import org.apache.jackrabbit.oak.plugins.observation.FilteringAwareObserver;
import org.apache.jackrabbit.oak.plugins.observation.FilteringDispatcher;
import org.apache.jackrabbit.oak.spi.commit.BackgroundObserver;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import sling-mock-oak.com.google.common.base.Preconditions;

public class FilteringObserver
implements Observer,
Closeable {
    static final CommitInfo NOOP_CHANGE = new CommitInfo("oak:unknown", "oak:unknown");
    private final BackgroundObserver backgroundObserver;
    private final Filter filter;
    private NodeState lastNoop;

    public FilteringObserver(@NotNull Executor executor, int queueLength, @NotNull Filter filter, @NotNull FilteringAwareObserver observer) {
        this(new BackgroundObserver(new FilteringDispatcher(Preconditions.checkNotNull(observer)), Preconditions.checkNotNull(executor), queueLength), filter);
    }

    public FilteringObserver(@NotNull BackgroundObserver backgroundObserver, @NotNull Filter filter) {
        this.backgroundObserver = backgroundObserver;
        this.filter = Preconditions.checkNotNull(filter);
    }

    public BackgroundObserver getBackgroundObserver() {
        return this.backgroundObserver;
    }

    @Override
    public final void contentChanged(@NotNull NodeState root, @NotNull CommitInfo info) {
        if (this.filter.excludes(root, info)) {
            this.lastNoop = root;
            return;
        }
        if (this.lastNoop != null) {
            this.backgroundObserver.contentChanged(this.lastNoop, NOOP_CHANGE);
            this.lastNoop = null;
        }
        this.backgroundObserver.contentChanged(root, info);
    }

    @Override
    public void close() {
        this.backgroundObserver.close();
    }
}

