/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.lock;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import org.apache.jackrabbit.oak.jcr.delegate.NodeDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.apache.jackrabbit.oak.jcr.session.NodeImpl;
import org.apache.jackrabbit.oak.jcr.session.SessionContext;
import org.apache.jackrabbit.oak.jcr.session.operation.NodeOperation;
import org.apache.jackrabbit.oak.jcr.session.operation.SessionOperation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sling-mock-oak.com.google.common.base.Preconditions;

public final class LockImpl
implements Lock {
    private final SessionContext context;
    private final NodeDelegate delegate;

    public LockImpl(@NotNull SessionContext context, @NotNull NodeDelegate delegate) {
        this.context = Preconditions.checkNotNull(context);
        this.delegate = Preconditions.checkNotNull(delegate);
    }

    public Node getNode() {
        try {
            return NodeImpl.createNode(this.delegate, this.context);
        }
        catch (RepositoryException e) {
            throw new RuntimeException("Unable to access the lock node", e);
        }
    }

    public String getLockOwner() {
        return this.savePerformNullable(new NodeOperation<String>(this.delegate, "getLockOwner"){

            @Override
            public String performNullable() {
                return this.node.getLockOwner();
            }
        });
    }

    public boolean isDeep() {
        return this.getSessionDelegate().safePerform(new NodeOperation<Boolean>(this.delegate, "isDeep"){

            @Override
            @NotNull
            public Boolean perform() {
                return this.node.holdsLock(true);
            }
        });
    }

    public boolean isLive() {
        return this.context.getSession().isLive() && this.getSessionDelegate().safePerform(new NodeOperation<Boolean>(this.delegate, "isLive"){

            @Override
            @NotNull
            public Boolean perform() {
                return this.node.holdsLock(false);
            }
        }) != false;
    }

    public String getLockToken() {
        return this.savePerformNullable(new NodeOperation<String>(this.delegate, "getLockToken"){

            @Override
            public String performNullable() {
                String token = this.node.getPath();
                if (LockImpl.this.context.getOpenScopedLocks().contains(token)) {
                    return token;
                }
                if (LockImpl.this.context.getSessionScopedLocks().contains(token)) {
                    return null;
                }
                if (this.node.isLockOwner(LockImpl.this.context.getSessionDelegate().getAuthInfo().getUserID())) {
                    return token;
                }
                return null;
            }
        });
    }

    public long getSecondsRemaining() {
        if (this.isLive()) {
            return Long.MAX_VALUE;
        }
        return -1L;
    }

    public boolean isSessionScoped() {
        return this.getSessionDelegate().safePerform(new NodeOperation<Boolean>(this.delegate, "isSessionScoped"){

            @Override
            @NotNull
            public Boolean perform() {
                String path = this.node.getPath();
                return LockImpl.this.context.getSessionScopedLocks().contains(path);
            }
        });
    }

    public boolean isLockOwningSession() {
        return this.getSessionDelegate().safePerform(new NodeOperation<Boolean>(this.delegate, "isLockOwningSessions"){

            @Override
            @NotNull
            public Boolean perform() {
                String path = this.node.getPath();
                return LockImpl.this.context.getSessionScopedLocks().contains(path) || LockImpl.this.context.getOpenScopedLocks().contains(path);
            }
        });
    }

    public void refresh() throws LockException {
        if (!this.isLive()) {
            throw new LockException("This lock is not alive");
        }
    }

    private SessionDelegate getSessionDelegate() {
        return this.context.getSessionDelegate();
    }

    @Nullable
    private <U> U savePerformNullable(@NotNull SessionOperation<U> op) {
        try {
            return this.context.getSessionDelegate().performNullable(op);
        }
        catch (RepositoryException e) {
            throw new RuntimeException("Unexpected exception thrown by operation " + op, e);
        }
    }
}

