/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.constraint;

import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.core.query.lucene.ScoreNode;
import org.apache.jackrabbit.core.query.lucene.Util;
import org.apache.jackrabbit.core.query.lucene.constraint.DynamicOperand;
import org.apache.jackrabbit.core.query.lucene.constraint.EvaluationContext;
import org.apache.jackrabbit.core.query.lucene.constraint.PropertyValueOperand;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.core.value.ValueFactoryImpl;
import org.apache.jackrabbit.spi.QValueFactory;

public class LengthOperand
extends DynamicOperand {
    private final PropertyValueOperand property;

    public LengthOperand(PropertyValueOperand property) {
        this.property = property;
    }

    public Value[] getValues(ScoreNode sn, EvaluationContext context) throws RepositoryException {
        PropertyState ps = this.property.getPropertyState(sn, context);
        if (ps == null) {
            return EMPTY;
        }
        ValueFactoryImpl vf = (ValueFactoryImpl)context.getSession().getValueFactory();
        QValueFactory qvf = vf.getQValueFactory();
        InternalValue[] values = ps.getValues();
        Value[] lengths = new Value[values.length];
        for (int i = 0; i < lengths.length; ++i) {
            int type = values[i].getType();
            long len = type == 7 ? (long)vf.createValue(qvf.create(values[i].getName())).getString().length() : (type == 8 ? (long)vf.createValue(qvf.create(values[i].getPath())).getString().length() : Util.getLength(values[i]));
            lengths[i] = vf.createValue(len);
        }
        return lengths;
    }
}

