/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.sitemap.impl.builder.extensions;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.sling.sitemap.builder.extensions.GoogleImageExtension;
import org.apache.sling.sitemap.spi.builder.AbstractExtension;
import org.apache.sling.sitemap.spi.builder.SitemapExtensionProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;

@Component(property={"extension.interface=org.apache.sling.sitemap.builder.extensions.GoogleImageExtension", "extension.prefix=image", "extension.namespace=http://www.google.com/schemas/sitemap-image/1.1", "extension.localName=image"})
public class GoogleImageExtensionProvider
implements SitemapExtensionProvider {
    @Override
    @NotNull
    public AbstractExtension newInstance() {
        return new ExtensionImpl();
    }

    private static class ExtensionImpl
    extends AbstractExtension
    implements GoogleImageExtension {
        private String url;
        private String caption;
        private String geoLocation;
        private String title;
        private String license;

        private ExtensionImpl() {
        }

        private static String required(String object, String message) throws XMLStreamException {
            if (object == null) {
                throw new XMLStreamException(message);
            }
            return object;
        }

        @Override
        @NotNull
        public GoogleImageExtension setUrl(@NotNull String location) {
            this.url = location;
            return this;
        }

        @Override
        @NotNull
        public GoogleImageExtension setCaption(@Nullable String caption) {
            this.caption = caption;
            return this;
        }

        @Override
        @NotNull
        public GoogleImageExtension setGeoLocation(@Nullable String geoLocation) {
            this.geoLocation = geoLocation;
            return this;
        }

        @Override
        @NotNull
        public GoogleImageExtension setTitle(@Nullable String title) {
            this.title = title;
            return this;
        }

        @Override
        @NotNull
        public GoogleImageExtension setLicense(@Nullable String licenseLocation) {
            this.license = licenseLocation;
            return this;
        }

        @Override
        public void writeTo(@NotNull XMLStreamWriter writer) throws XMLStreamException {
            writer.writeStartElement("loc");
            writer.writeCharacters(ExtensionImpl.required(this.url, "image:loc is missing"));
            writer.writeEndElement();
            if (this.caption != null) {
                writer.writeStartElement("caption");
                writer.writeCharacters(this.caption);
                writer.writeEndElement();
            }
            if (this.geoLocation != null) {
                writer.writeStartElement("geo_location");
                writer.writeCharacters(this.geoLocation);
                writer.writeEndElement();
            }
            if (this.title != null) {
                writer.writeStartElement("title");
                writer.writeCharacters(this.title);
                writer.writeEndElement();
            }
            if (this.license != null) {
                writer.writeStartElement("license");
                writer.writeCharacters(this.license);
                writer.writeEndElement();
            }
        }
    }
}

