/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.jst;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.scripting.jst.JsCodeGenerator;

public class JsCodeGeneratorServlet
extends SlingSafeMethodsServlet {
    private final JsCodeGenerator codeGenerator = new JsCodeGenerator();

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        Reader scriptReader = JsCodeGeneratorServlet.getReader(request.getResource());
        PrintWriter output = new PrintWriter((OutputStream)response.getOutputStream());
        response.setContentType(" application/x-javascript");
        this.codeGenerator.generateCode(scriptReader, output);
        output.flush();
    }

    static Reader getReader(Resource resource) throws IOException {
        if (resource == null) {
            throw new IllegalArgumentException("Resource is null");
        }
        InputStream ins = (InputStream)resource.adaptTo(InputStream.class);
        if (ins == null) {
            throw new IOException("Resource " + resource.getPath() + " cannot be adapted to an InputStream");
        }
        String enc = (String)resource.getResourceMetadata().get((Object)"sling.characterEncoding");
        if (enc == null) {
            enc = "UTF-8";
        }
        return new InputStreamReader(ins, enc);
    }
}

