/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.query.impl.iterator;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.sling.query.api.internal.Option;
import org.apache.sling.query.api.internal.TreeProvider;
import org.apache.sling.query.impl.iterator.AbstractIterator;
import org.apache.sling.query.impl.util.LazyList;

public class DescendantsIterator<T>
extends AbstractIterator<Option<T>> {
    private final Iterator<Option<T>> input;
    private Option<T> current;
    private Iterator<T> descendants;
    private final TreeProvider<T> provider;

    public DescendantsIterator(Iterator<Option<T>> input, Iterator<T> descendants, TreeProvider<T> provider) {
        this.input = input;
        this.current = null;
        this.descendants = new ArrayList<T>(new LazyList<T>(descendants)).iterator();
        this.provider = provider;
    }

    @Override
    protected Option<T> getElement() {
        if (this.current == null) {
            if (this.input.hasNext()) {
                this.current = this.input.next();
            } else {
                return null;
            }
        }
        return this.getDescendant();
    }

    private Option<T> getDescendant() {
        while (this.descendants.hasNext()) {
            T descendantCandidate = this.descendants.next();
            if (!this.provider.isDescendant(this.current.getElement(), descendantCandidate)) continue;
            this.descendants.remove();
            return Option.of(descendantCandidate, this.current.getArgumentId());
        }
        Option result = Option.empty(this.current.getArgumentId());
        this.current = null;
        return result;
    }
}

