/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.nosql.generic.resource.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.nosql.generic.resource.impl.NoSqlResource;
import org.apache.sling.nosql.generic.resource.impl.NoSqlValueMap;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.apache.sling.testing.mock.sling.junit.SlingContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public abstract class AbstractNoSqlResourceProviderTest {
    private static final String STRING_VALUE = "value1";
    private static final String[] STRING_ARRAY_VALUE = new String[]{"value1", "value2"};
    private static final int INTEGER_VALUE = 25;
    private static final double DOUBLE_VALUE = 3.555;
    private static final boolean BOOLEAN_VALUE = true;
    private static final Date DATE_VALUE = new Date(10000L);
    private static final Calendar CALENDAR_VALUE = Calendar.getInstance();
    private static final byte[] BINARY_VALUE = new byte[]{1, 2, 3, 4, 5, 6};
    @Rule
    public SlingContext context = new SlingContext(ResourceResolverType.JCR_MOCK);

    protected abstract void registerResourceProviderFactory();

    protected abstract Resource testRoot();

    @Before
    public void setUp() throws Exception {
        this.registerResourceProviderFactory();
        Resource rootNode = this.testRoot();
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("jcr:primaryType", "nt:unstructured");
        props.put("stringProp", STRING_VALUE);
        props.put("stringArrayProp", STRING_ARRAY_VALUE);
        props.put("integerProp", 25);
        props.put("doubleProp", 3.555);
        props.put("booleanProp", true);
        props.put("dateProp", DATE_VALUE);
        props.put("calendarProp", CALENDAR_VALUE);
        props.put("binaryProp", new ByteArrayInputStream(BINARY_VALUE));
        Resource node1 = this.context.resourceResolver().create(rootNode, "node1", props);
        this.context.resourceResolver().create(node1, "node11", (Map)ImmutableMap.builder().put((Object)"stringProp11", (Object)STRING_VALUE).build());
        this.context.resourceResolver().create(node1, "node12", (Map)ValueMap.EMPTY);
        this.context.resourceResolver().commit();
    }

    @After
    public void tearDown() {
        this.context.resourceResolver().revert();
        try {
            this.context.resourceResolver().delete(this.testRoot());
            this.context.resourceResolver().commit();
        }
        catch (PersistenceException persistenceException) {
            // empty catch block
        }
    }

    @Test
    public void testSimpleProperties() throws IOException {
        Resource resource1 = this.context.resourceResolver().getResource(this.testRoot().getPath() + "/node1");
        Assert.assertTrue((boolean)(resource1 instanceof NoSqlResource));
        Assert.assertNotNull((Object)resource1);
        Assert.assertEquals((Object)"node1", (Object)resource1.getName());
        ValueMap props = ResourceUtil.getValueMap((Resource)resource1);
        Assert.assertEquals((Object)STRING_VALUE, (Object)props.get("stringProp", String.class));
        Assert.assertArrayEquals((Object[])STRING_ARRAY_VALUE, (Object[])((Object[])props.get("stringArrayProp", String[].class)));
        Assert.assertEquals((Object)25, (Object)props.get("integerProp", Integer.class));
        Assert.assertEquals((double)3.555, (double)((Double)props.get("doubleProp", Double.class)), (double)1.0E-4);
        Assert.assertEquals((Object)true, (Object)props.get("booleanProp", Boolean.class));
    }

    @Test
    public void testSimpleProperties_DeepPathAccess() throws IOException {
        Resource resource1 = this.context.resourceResolver().getResource(this.testRoot().getPath());
        Assert.assertNotNull((Object)resource1);
        Assert.assertEquals((Object)this.testRoot().getName(), (Object)resource1.getName());
        ValueMap props = ResourceUtil.getValueMap((Resource)resource1);
        Assert.assertEquals((Object)STRING_VALUE, (Object)props.get("node1/stringProp", String.class));
        Assert.assertArrayEquals((Object[])STRING_ARRAY_VALUE, (Object[])((Object[])props.get("node1/stringArrayProp", String[].class)));
        Assert.assertEquals((Object)25, (Object)props.get("node1/integerProp", Integer.class));
        Assert.assertEquals((double)3.555, (double)((Double)props.get("node1/doubleProp", Double.class)), (double)1.0E-4);
        Assert.assertEquals((Object)true, (Object)props.get("node1/booleanProp", Boolean.class));
        Assert.assertEquals((Object)STRING_VALUE, (Object)props.get("node1/node11/stringProp11", String.class));
    }

    @Test
    public void testDateProperty() throws IOException {
        Resource resource1 = this.context.resourceResolver().getResource(this.testRoot().getPath() + "/node1");
        ValueMap props = ResourceUtil.getValueMap((Resource)resource1);
        Assert.assertEquals((Object)DATE_VALUE, (Object)props.get("dateProp", Date.class));
    }

    @Test
    public void testDatePropertyToCalendar() throws IOException {
        Resource resource1 = this.context.resourceResolver().getResource(this.testRoot().getPath() + "/node1");
        ValueMap props = ResourceUtil.getValueMap((Resource)resource1);
        Calendar calendarValue = (Calendar)props.get("dateProp", Calendar.class);
        Assert.assertNotNull((Object)calendarValue);
        Assert.assertEquals((Object)DATE_VALUE, (Object)calendarValue.getTime());
    }

    @Test
    public void testCalendarProperty() throws IOException {
        Resource resource1 = this.context.resourceResolver().getResource(this.testRoot().getPath() + "/node1");
        ValueMap props = ResourceUtil.getValueMap((Resource)resource1);
        Assert.assertEquals((Object)CALENDAR_VALUE.getTime(), (Object)((Calendar)props.get("calendarProp", Calendar.class)).getTime());
    }

    @Test
    public void testCalendarPropertyToDate() throws IOException {
        Resource resource1 = this.context.resourceResolver().getResource(this.testRoot().getPath() + "/node1");
        ValueMap props = ResourceUtil.getValueMap((Resource)resource1);
        Date dateValue = (Date)props.get("calendarProp", Date.class);
        Assert.assertNotNull((Object)dateValue);
        Assert.assertEquals((Object)CALENDAR_VALUE.getTime(), (Object)dateValue);
    }

    @Test
    public void testListChildren() throws IOException {
        Resource resource1 = this.context.resourceResolver().getResource(this.testRoot().getPath() + "/node1");
        ImmutableList children = ImmutableList.copyOf((Iterator)resource1.listChildren());
        Assert.assertEquals((long)2L, (long)children.size());
        Assert.assertEquals((Object)"node11", (Object)((Resource)children.get(0)).getName());
        Assert.assertEquals((Object)"node12", (Object)((Resource)children.get(1)).getName());
    }

    @Test
    public void testBinaryData() throws IOException {
        Resource resource1 = this.context.resourceResolver().getResource(this.testRoot().getPath() + "/node1");
        InputStream is = (InputStream)ResourceUtil.getValueMap((Resource)resource1).get("binaryProp", InputStream.class);
        byte[] dataFromResource = IOUtils.toByteArray((InputStream)is);
        is.close();
        Assert.assertArrayEquals((byte[])BINARY_VALUE, (byte[])dataFromResource);
    }

    @Test
    public void testValueMapTypes() throws IOException {
        Resource resource1 = this.context.resourceResolver().getResource(this.testRoot().getPath() + "/node1");
        ValueMap valueMap = resource1.getValueMap();
        for (Map.Entry entry : valueMap.entrySet()) {
            Assert.assertTrue((boolean)NoSqlValueMap.isValidType(entry.getValue().getClass()));
        }
    }

    @Test
    public void testPrimaryTypeResourceType() throws PersistenceException {
        Resource resource = this.context.resourceResolver().getResource(this.testRoot().getPath());
        Assert.assertEquals((Object)"nt:unstructured", (Object)resource.getResourceType());
    }

    @Test
    public void testCreateWithNullMap() throws IOException {
        Resource resource1 = this.context.resourceResolver().getResource(this.testRoot().getPath() + "/node1");
        this.context.resourceResolver().create(resource1, "nullMap", null);
    }
}

