/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.teleporter.client;

import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.junit.rules.TeleporterRule;
import org.apache.sling.testing.teleporter.client.ClientSideTeleporter;
import org.junit.Assert;

public class DefaultPropertyBasedCustomizer
implements TeleporterRule.Customizer {
    static final String PROPERTY_BASE_URL = "ClientSideTeleporter.baseUrl";
    static final String PROPERTY_INCLUDE_DEPENDENCY_PREFIXES = "ClientSideTeleporter.includeDependencyPrefixes";
    static final String PROPERTY_EXCLUDE_DEPENDENCY_PREFIXES = "ClientSideTeleporter.excludeDependencyPrefixes";
    static final String PROPERTY_EMBED_CLASSES = "ClientSideTeleporter.embedClasses";
    static final String PROPERTY_EMBED_CLASSES_DIRECTORIES = "ClientSideTeleporter.embedClassesDirectories";
    static final String PROPERTY_SERVER_PASSWORD = "ClientSideTeleporter.serverPassword";
    static final String PROPERTY_SERVER_USERNAME = "ClientSideTeleporter.serverUsername";
    static final String PROPERTY_TESTREADY_TIMEOUT_SECONDS = "ClientSideTeleporter.testReadyTimeoutSeconds";
    static final String PROPERTY_TESTBUNDLE_DIRECTORY = "ClientSideTeleporter.testBundleDirectory";
    static final String PROPERTY_ENABLE_LOGGING = "ClientSideTeleporter.enableLogging";
    static final String PROPERTY_PREVENT_TO_UNINSTALL_BUNDLE = "ClientSideTeleporter.preventToUninstallBundle";
    static final String PROPERTY_ADDITIONAL_BUNDLE_HEADERS = "ClientSideTeleporter.additionalBundleHeaders";
    static final String LIST_SEPARATOR = ",";
    static final String NAME_VALUE_SEPARATOR = ":";
    private final int testReadyTimeout = Integer.getInteger("ClientSideTeleporter.testReadyTimeoutSeconds", 12);
    private final String serverUsername = System.getProperty("ClientSideTeleporter.serverUsername", "admin");
    private final String serverPassword = System.getProperty("ClientSideTeleporter.serverPassword", "admin");
    private final String includeDependencyPrefixes = System.getProperty("ClientSideTeleporter.includeDependencyPrefixes");
    private final String excludeDependencyPrefixes = System.getProperty("ClientSideTeleporter.excludeDependencyPrefixes");
    private final String embedClasses = System.getProperty("ClientSideTeleporter.embedClasses");
    private final String embedClassesDirectories = System.getProperty("ClientSideTeleporter.embedClassesDirectories");
    private final String baseUrl = System.getProperty("ClientSideTeleporter.baseUrl");
    private final String testBundleDirectory;
    private final boolean enableLogging;
    private final boolean preventToUninstallBundle;
    private final String additionalBundleHeaders = System.getProperty("ClientSideTeleporter.additionalBundleHeaders");

    public DefaultPropertyBasedCustomizer() {
        this.testBundleDirectory = System.getProperty(PROPERTY_TESTBUNDLE_DIRECTORY);
        this.enableLogging = Boolean.getBoolean(PROPERTY_ENABLE_LOGGING);
        this.preventToUninstallBundle = Boolean.getBoolean(PROPERTY_PREVENT_TO_UNINSTALL_BUNDLE);
    }

    public void customize(TeleporterRule rule, String options) {
        ClientSideTeleporter cst = (ClientSideTeleporter)rule;
        if (StringUtils.isBlank((CharSequence)this.baseUrl)) {
            Assert.fail((String)"The mandatory system property ClientSideTeleporter.baseUrl is not set!");
        }
        cst.setEnableLogging(this.enableLogging);
        cst.setPreventToUninstallBundle(this.preventToUninstallBundle);
        if (StringUtils.isNotBlank((CharSequence)this.testBundleDirectory)) {
            cst.setDirectoryForPersistingTestBundles(new File(this.testBundleDirectory));
        }
        cst.setBaseUrl(this.baseUrl);
        cst.setServerCredentials(this.serverUsername, this.serverPassword);
        cst.setTestReadyTimeoutSeconds(this.testReadyTimeout);
        if (StringUtils.isNotBlank((CharSequence)this.includeDependencyPrefixes)) {
            for (String includeDependencyPrefix : this.includeDependencyPrefixes.split(LIST_SEPARATOR)) {
                if (!StringUtils.isNotBlank((CharSequence)includeDependencyPrefix)) continue;
                cst.includeDependencyPrefix(includeDependencyPrefix);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.excludeDependencyPrefixes)) {
            for (String excludeDependencyPrefix : this.excludeDependencyPrefixes.split(LIST_SEPARATOR)) {
                if (!StringUtils.isNotBlank((CharSequence)excludeDependencyPrefix)) continue;
                cst.excludeDependencyPrefix(excludeDependencyPrefix);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.embedClassesDirectories)) {
            for (String embedClassesDirectory : this.embedClassesDirectories.split(LIST_SEPARATOR)) {
                if (!StringUtils.isNotBlank((CharSequence)embedClassesDirectory)) continue;
                try {
                    cst.embedClassesDirectory(new File(embedClassesDirectory));
                }
                catch (IOException | ClassNotFoundException e) {
                    Assert.fail((String)("Could not load class directory '" + embedClassesDirectory + "': " + e.getMessage()));
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.embedClasses)) {
            for (String embedClass : this.embedClasses.split(LIST_SEPARATOR)) {
                if (!StringUtils.isNotBlank((CharSequence)embedClass)) continue;
                try {
                    Class<?> clazz = this.getClass().getClassLoader().loadClass(embedClass);
                    cst.embedClass(clazz);
                }
                catch (ClassNotFoundException e) {
                    Assert.fail((String)("Could not load class with name '" + embedClass + "': " + e.getMessage()));
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.additionalBundleHeaders)) {
            for (String additionalBundleHeader : this.additionalBundleHeaders.split(LIST_SEPARATOR)) {
                if (!StringUtils.isNotBlank((CharSequence)additionalBundleHeader)) continue;
                int pos = additionalBundleHeader.indexOf(NAME_VALUE_SEPARATOR);
                if (pos < 1 || pos >= additionalBundleHeader.length() - 1) {
                    Assert.fail((String)("Each entry given to property 'ClientSideTeleporter.additionalBundleHeaders' must have exactly the format <name>:<value>, but one entry is '" + additionalBundleHeader + "'."));
                }
                cst.addAdditionalBundleHeader(additionalBundleHeader.substring(0, pos), additionalBundleHeader.substring(pos + 1));
            }
        }
    }
}

