/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.core.internal;

import org.apache.sling.ide.eclipse.core.DefaultSlingLaunchpadConfiguration;
import org.apache.sling.ide.eclipse.core.ISlingLaunchpadConfiguration;
import org.apache.sling.ide.eclipse.core.internal.SlingLaunchpadServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;

public class SlingLaunchpadConfiguration
implements ISlingLaunchpadConfiguration {
    private SlingLaunchpadServer server;

    public SlingLaunchpadConfiguration(SlingLaunchpadServer server) {
        this.server = server;
    }

    @Override
    public boolean bundleInstallLocally() {
        return this.workingCopy().getAttribute("launchpad.installLocally", true);
    }

    @Override
    public int getPort() {
        return this.workingCopy().getAttribute("launchpad.port", DefaultSlingLaunchpadConfiguration.INSTANCE.getPort());
    }

    @Override
    public int getDebugPort() {
        return this.workingCopy().getAttribute("launchpad.debugPort", DefaultSlingLaunchpadConfiguration.INSTANCE.getDebugPort());
    }

    private IServerWorkingCopy workingCopy() {
        IServerWorkingCopy workingCopy = this.server.getServerWorkingCopy();
        this.server.getServer().createWorkingCopy();
        if (workingCopy == null) {
            workingCopy = this.server.getServer().createWorkingCopy();
        }
        return workingCopy;
    }

    public void setPort(int port) {
        this.workingCopy().setAttribute("launchpad.port", port);
    }

    public void setDebugPort(int debugPort) {
        this.workingCopy().setAttribute("launchpad.debugPort", debugPort);
    }

    @Override
    public String getContextPath() {
        return this.workingCopy().getAttribute("launchpad.contextPath", "/");
    }

    public void setContextPath(String contextPath) {
        this.workingCopy().setAttribute("launchpad.contextPath", contextPath);
    }

    @Override
    public String getUsername() {
        return this.workingCopy().getAttribute("launchpad.username", DefaultSlingLaunchpadConfiguration.INSTANCE.getUsername());
    }

    public void setUsername(String username) {
        this.workingCopy().setAttribute("launchpad.username", username);
    }

    @Override
    public String getPassword() {
        return this.workingCopy().getAttribute("launchpad.password", DefaultSlingLaunchpadConfiguration.INSTANCE.getPassword());
    }

    public void setPassword(String password) {
        this.workingCopy().setAttribute("launchpad.password", password);
    }

    @Override
    public boolean resolveSourcesInDebugMode() {
        return this.workingCopy().getAttribute("launchpad.resolveSources", true);
    }
}

