/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.impl.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.jcr.RepositoryException;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.vault.fs.api.Artifact;
import org.apache.jackrabbit.vault.fs.api.SerializationType;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CompressionUtil {
    private static final Logger log = LoggerFactory.getLogger(CompressionUtil.class);
    public static final boolean ENV_SUPPORTS_COMPRESSION_LEVEL_CHANGE = CompressionUtil.checkEnvironmentSupportsCompressionSwitch();
    private static final long MIN_AUTO_DETECTION_LENGTH = 117760L;
    private static final int SAMPLE_LENGTH = 256;
    private static final Set<String> INCOMPRESSIBLE_MIME_TYPES = new HashSet<String>(Arrays.asList("image/gif", "image/jpeg", "image/png", "multipart/x-gzip", "video/mp4", "application/gzip", "application/java-archive", "application/mp4", "application/x-7z-compressed", "application/x-compressed", "application/x-gzip", "application/x-rar-compressed", "application/zip", "application/zlib", "audio/mpeg"));
    private static final Set<String> COMPRESSIBLE_MIME_TYPES = new HashSet<String>(Arrays.asList("application/xml", "application/java", "application/json", "application/javascript", "application/ecmascript"));

    public static int isCompressible(@NotNull Artifact artifact) {
        if (SerializationType.GENERIC == artifact.getSerializationType()) {
            long contentLength;
            String contentType = artifact.getContentType();
            if (contentType != null) {
                if (CompressionUtil.isCompressibleContentType(contentType = contentType.toLowerCase())) {
                    return 1;
                }
                if (CompressionUtil.isIncompressibleContentType(contentType)) {
                    return -1;
                }
            }
            if ((contentLength = artifact.getContentLength()) > 117760L) {
                return CompressionUtil.seemsCompressible(artifact);
            }
        }
        return 0;
    }

    static boolean isCompressibleContentType(@NotNull String mimeType) {
        return mimeType.startsWith("text/") || COMPRESSIBLE_MIME_TYPES.contains(mimeType);
    }

    static boolean isIncompressibleContentType(@NotNull String mimeType) {
        return INCOMPRESSIBLE_MIME_TYPES.contains(mimeType);
    }

    static int seemsCompressible(@NotNull Artifact artifact) {
        int n;
        block8: {
            InputStream stream = artifact.getInputStream();
            try {
                byte[] sample = IOUtils.toByteArray(stream, 256);
                int n2 = n = CompressionUtil.isCompressible(sample, 256) ? 1 : -1;
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | RepositoryException e) {
                    log.warn(e.getMessage(), (Throwable)e);
                    return 0;
                }
            }
            stream.close();
        }
        return n;
    }

    private static boolean isCompressible(byte[] data, int len) {
        int[] sum = new int[16];
        for (int i = 0; i < len; ++i) {
            int x;
            int n = x = (data[i] & 0xFF) >> 4;
            sum[n] = sum[n] + 1;
        }
        int r = 0;
        for (int x : sum) {
            long v = ((long)x << 32) / (long)len;
            r += 63 - Long.numberOfLeadingZeros(v + 1L);
        }
        return len * r < 438 * len;
    }

    private static boolean checkEnvironmentSupportsCompressionSwitch() {
        Throwable exception = null;
        ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
        byte[] nullBytes = new byte[0x100000];
        try (ZipOutputStream zipOut = new ZipOutputStream(byteArrayOut);){
            zipOut.setLevel(1);
            zipOut.putNextEntry(new ZipEntry("deflated.bin"));
            zipOut.write(nullBytes);
            zipOut.closeEntry();
            zipOut.putNextEntry(new ZipEntry("stored.bin"));
            zipOut.setLevel(9);
            zipOut.write(nullBytes);
            zipOut.closeEntry();
        }
        catch (Throwable e) {
            exception = e;
        }
        if (exception == null) {
            try (ZipInputStream zipIn = new ZipInputStream(new ByteArrayInputStream(byteArrayOut.toByteArray()));){
                for (int i = 0; i < 2; ++i) {
                    zipIn.getNextEntry();
                    while (zipIn.read(nullBytes) >= 0) {
                    }
                }
            }
            catch (Throwable e) {
                exception = e;
            }
        }
        if (exception != null) {
            log.info("The current environment doesn't support switching compression level for individual JarEntries, see JCRVLT-257");
            return false;
        }
        return true;
    }
}

